package com.biz.crm.config;

import com.biz.crm.webservice.service.IKmsOrderWebService;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import javax.xml.ws.Endpoint;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.eisp.config
 * @Description: TODO
 * @date 2019/8/8 下午1:39
 */
@Configuration
public class WebserviceConfig {

    @Value("${webservices.username:ADMIN}")
    private String username;
    @Value("${webservices.password:y@x*iK$@5PsQEMkP}")
    private String password;

    @Resource
    private IKmsOrderWebService kmsOrderWebService;

    @Autowired
    private Bus bus;

    @Bean
    public ServletRegistrationBean<CXFServlet> cxfServlet() {
        return new ServletRegistrationBean<CXFServlet>(new CXFServlet(), "/bizcrm/*");
    }

    /**
     * 访问方式 http://localhost:8317/kms/bizcrm/webservice/kmsOrder?wsdl
     * 查询商超订货单接口
     *
     * @return
     */
    @Bean
    public Endpoint kmsOrderFormEndpoint() {
        EndpointImpl endpoint = new EndpointImpl(bus, kmsOrderWebService);
        endpoint.getInInterceptors().add(new AuthInterceptor(username, password));
        endpoint.publish("webservice/kmsOrder");

        return endpoint;
    }

}
