package com.biz.crm.finance.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 稽核模板
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Slf4j
@RestController
@RequestMapping("/kmsaudittemplate")
@Api(tags = "稽核模板")
public class KmsAuditTemplateController {
    @Autowired
    private IKmsAuditTemplateService kmsAuditTemplateService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsAuditTemplateRespVo>> list(@RequestBody KmsAuditTemplateReqVo kmsAuditTemplateReqVo) {
        PageResult<KmsAuditTemplateRespVo> result=kmsAuditTemplateService.findList(kmsAuditTemplateReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsAuditTemplateRespVo> query(@RequestBody KmsAuditTemplateReqVo kmsAuditTemplateReqVo) {
        KmsAuditTemplateRespVo respVo=kmsAuditTemplateService.query(kmsAuditTemplateReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsAuditTemplateReqVo kmsAuditTemplateReqVo) {
        kmsAuditTemplateService.save(kmsAuditTemplateReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsAuditTemplateReqVo kmsAuditTemplateReqVo) {
        kmsAuditTemplateService.update(kmsAuditTemplateReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        KmsAuditTemplateReqVo kmsAuditTemplateReqVo = new KmsAuditTemplateReqVo();
        kmsAuditTemplateReqVo.setIds(ids);
        kmsAuditTemplateService.deleteBatch(kmsAuditTemplateReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        KmsAuditTemplateReqVo kmsAuditTemplateReqVo = new KmsAuditTemplateReqVo();
        kmsAuditTemplateReqVo.setIds(ids);
        kmsAuditTemplateService.enableBatch(kmsAuditTemplateReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        KmsAuditTemplateReqVo kmsAuditTemplateReqVo = new KmsAuditTemplateReqVo();
        kmsAuditTemplateReqVo.setIds(ids);
        kmsAuditTemplateService.disableBatch(kmsAuditTemplateReqVo);
        return Result.ok("禁用成功");
    }
}
