package com.biz.crm.finance.funcation;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.constant.KmsConstant;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.annotation.KmsFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.function
 * @ClassName KmsSoFunction
 * @Author Gavin
 * @Date 2021/6/22 上午11:08
 * @Description 门店+订单
 */
@KmsFunction(code = KmsAuditConditionEnum.SO, name = "门店+订单号", desc = "稽核条件")
@Slf4j
public class KmsSoFunction implements BaseAuditFunction {
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;

    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;

    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;

    /**
     * 数据汇总
     * @param e
     * @param a
     */
    @Override
    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a , KmsAuditTemplateDirectRespVo templateDirectRespVo, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {

    }

    /**
     * 构建稽核对象信息
     * @param afe
     * @param e
     * @param templateDirectRespVo
     * @return
     */
    private KmsAuditFormEntity buildAuditForm(KmsAuditFormEntity afe, KmsSapInvoiceEntity e, KmsAuditTemplateDirectRespVo templateDirectRespVo) {
        if(ObjectUtils.isEmpty(afe)) {
            afe = new KmsAuditFormEntity();
            afe.setKaOrderNumber(e.getBstkd());
            afe.setDirectName(templateDirectRespVo.getDirectName());
            afe.setAuditNumber(CodeUtil.generateCode("kms_audit_code"));
            afe.setStoreCode(KmsUtils.removeFrontZero(e.getKunnr()));
            afe.setStoreName(e.getKunnrname());
            afe.setBukrs(e.getBukrs());
            afe.setOrgCode(e.getOrgCode());
            afe.setCreateOrgCode(e.getOrgCode());
            afe.setSapPostingDate(e.getFkdat());
            afe.setSapMaterielCode(KmsUtils.removeFrontZero(e.getMatnr()));
            afe.setSapMaterielName(e.getMaktx());
            afe.setSapQuantity("0");
            afe.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
            afe.setAcceptanceQuantity("0");
            afe.setSapAmountNot("0");
            afe.setSapAmount("0");
            afe.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
            afe.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
            afe.setAcceptanceAmount("0");
            afe.setAcceptanceAmountNot("0");
            afe.setAuditTemplateId(templateDirectRespVo.getAuditTemplateId());
            afe.setDifferencePrice(templateDirectRespVo.getDifferencePrice());
            afe.setAuditRule(templateDirectRespVo.getAuditRule());
        }
        return afe;
    }

    /**
     * 保存关系数据
     * @param afe
     * @param relationId
     * @param templateId
     */
    private void saveMatchRelation(KmsAuditFormEntity afe, String relationId,String templateId) {
        KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
        relationEntity.setAuditId(afe.getId());
        relationEntity.setAuditNumber(afe.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setRelationId(relationId);
        kmsAuditMatchRelationMapper.insert(relationEntity);
    }

    /**
     * 匹配数据信息
     * @param respVo
     * @param templateRespVo
     * @param conditionVo
     */
    @Override
    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setStoreCode(respVo.getStoreCode());
        //订单编号组成KMS-kaOrderNumber-storeCode
        String[] split = respVo.getKaOrderNumber().split("-");
        //防止条件缺失匹配到错误单据
        reqVo.setRelateKaOrderNumber(KmsConstant.ORDER_NUMBER);
        if(split.length == 3){
            reqVo.setRelateKaOrderNumber(split[1]);
        }
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = kmsAcceptanceFormMapper
                .findMatchedDS(reqVo);
        //查询已匹配验收单数据信息
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = kmsAcceptanceFormMapper
                .findMatchedSuccDS(reqVo);
        //移除已匹配数据
        acceptanceFormRespVos.removeAll(acceptanceFormSuccRespVos);
        acceptanceFormRespVos.forEach(a -> {
            a.setId(a.getHeaderId());
            //验收金额处理
            //KmsUtils.acceptanceAmountHandle(a, taxRate);
        });
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    /**
     * 查询已匹配验收单
     * @param respVo
     * @param templateRespVo
     */
    @Override
    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        //查询已匹配验收单数据信息
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = kmsAcceptanceFormMapper
                .findMatchedSuccDS(reqVo);
        acceptanceFormSuccRespVos.forEach(a -> {
            a.setId(a.getHeaderId());
            //验收金额处理
            //KmsUtils.acceptanceAmountHandle(a,taxRate);
        });
        respVo.setAcceptanceFormVos(acceptanceFormSuccRespVos);
    }

    /**
     * 数据绑定
     * @param afVo
     * @param templateRespVo
     */
    @Override
    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        List<KmsAcceptanceMatchRelationEntity> relationEntities = Lists.newArrayList();
        //验收单号
        List<String> accIds = Lists.newArrayList();
        //数据汇总
        afVo.getAcceptanceFormVos().forEach(o -> {
            //关系表
            KmsAcceptanceMatchRelationEntity relationEntity = KmsUtils.buildAcceptanceMatchRelation(o, afVo, templateRespVo.getId());
            relationEntities.add(relationEntity);
            accIds.add(o.getHeaderId());
        });
        //保存关系
        if(!CollectionUtils.isEmpty(relationEntities)){
            //设置状态为已匹配
            afVo.setIsAudit(YesNoEnum.yesNoEnum.yes.getValue());
            kmsAcceptanceMatchRelationService.saveBatch(relationEntities);
            //修改验收单状态为已匹配
            List<KmsAcceptanceFormEntity> acceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                a.setOrderStatus(KmsEnum.OrderStatus.S600.getValue());
                //a.setOrderStatusMsg(KmsEnum.OrderStatus.S600.getDescription());
                kmsAcceptanceFormMapper.updateById(a);
            });
            kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
        }
    }

    /**
     * 手动匹配/取消根据Ids查询验收数据
     * @param relationIdIds
     * @param respVo
     * @param templateRespVo
     */
    @Override
    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setIds(relationIdIds);
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = kmsAcceptanceFormMapper
                .findMatchedDS(reqVo);
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    /**
     * 取消数据绑定
     * @param relationIdIds
     * @param afVo
     * @param templateRespVo
     */
    @Override
    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单号
        List<String> accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> {
            accIds.add(o.getHeaderId());
        });
        //根据稽核ID，模版ID，关系数据ID删除稽核关系数据
        kmsAcceptanceMatchRelationService.lambdaUpdate()
                .eq(KmsAcceptanceMatchRelationEntity::getAuditId,afVo.getId())
                .eq(KmsAcceptanceMatchRelationEntity::getAuditTemplateId,templateRespVo.getId())
                .in(KmsAcceptanceMatchRelationEntity::getRelationId,relationIdIds).remove();
        //查询验收单是否还存在匹配记录
        List<KmsAcceptanceMatchRelationEntity> entities = kmsAcceptanceMatchRelationService.lambdaQuery()
                .in(KmsAcceptanceMatchRelationEntity::getHeaderId, accIds).list();
        Map<String, List<KmsAcceptanceMatchRelationEntity>> listMap = entities.stream()
                .collect(Collectors.groupingBy(KmsAcceptanceMatchRelationEntity::getHeaderId));
        //获取不存在匹配记录单验收单数据信息
        List<String> notRelationIds = Lists.newArrayList();
        accIds.forEach(o -> {
            List<KmsAcceptanceMatchRelationEntity> relationEntities = listMap.get(o);
            if(CollectionUtils.isEmpty(relationEntities)){
                notRelationIds.add(o);
            }
        });
        if(!CollectionUtils.isEmpty(notRelationIds)){
            //修改验收单状态为待处理
            List<KmsAcceptanceFormEntity> acceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                a.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                a.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
                kmsAcceptanceFormMapper.updateById(a);
            });
            kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
            afVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        }
    }

    /**
     * 查询未匹配验收单
     * @param page
     * @param reqVo
     * @return
     */
    @Override
    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        return kmsAcceptanceFormMapper.findNotMatchedDS(page, reqVo);
    }

    /**
     * 手动匹配查询待匹配验收单数据列表
     * @param respVo
     * @param templateRespVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setStoreCode(respVo.getStoreCode());
        //订单编号组成KMS-kaOrderNumber-storeCode
        String[] split = respVo.getKaOrderNumber().split("-");
        //防止条件缺失匹配到错误单据
        queryVo.setRelateKaOrderNumber(KmsConstant.ORDER_NUMBER);
        if(split.length == 3){
            queryVo.setRelateKaOrderNumber(split[1]);
        }
        //查询已匹配验收单数据信息
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        //查询已匹配验收单
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = kmsAcceptanceFormMapper
                .findMatchedSuccDS(queryVo);
        //验收单ID
        List<String> matchIds = acceptanceFormSuccRespVos.stream()
                .map(KmsAuditAcceptanceFormRespVo::getHeaderId)
                .distinct().collect(Collectors.toList());
        queryVo.setMatchIds(matchIds);
        //手动匹配查询待匹配验收单数据列表
        Page<KmsAuditAcceptanceFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = kmsAcceptanceFormMapper.findMatchedDS(page, queryVo);
        return PageResult.<KmsAuditAcceptanceFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询已匹配验收单数据列表
     * @param reqVo
     * @param respVo
     * @param templateRespVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        //查询已匹配验收单数据信息
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page<KmsAuditAcceptanceFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = kmsAcceptanceFormMapper.findMatchedSuccPDS(page, queryVo);
        return PageResult.<KmsAuditAcceptanceFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {

    }
}