package com.biz.crm.finance.funcation.base;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;

import java.util.List;

/**
 * @Description 稽核
 * @Author Gavin
 * @Date Created in 2021/6/21 下午4:49
 */
public interface BaseAuditFunction {
    /**
     * 数据汇总
     *
     * @param params
     * @return
     */
    void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo templateRespVo, KmsAuditTemplateDirectRespVo templateDirectRespVo, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities);

    /**
     * 匹配数据信息
     *
     * @param respVo
     * @param templateRespVo
     * @param conditionVo
     */
    void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 查询已匹配验收单
     *
     * @param respVo
     * @param templateRespVo
     */
    void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 数据绑定
     *
     * @param afVo
     * @param templateRespVo
     */
    void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 手动匹配/取消根据Ids查询验收数据
     *
     * @param relationIdIds
     * @param respVo
     * @param templateRespVo
     */
    void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 取消数据绑定
     *
     * @param relationIdIds
     * @param afVo
     * @param templateRespVo
     */
    void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 查询未匹配验收单
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo);

    /**
     * 手动匹配查询待匹配验收单数据列表
     *
     * @param respVo
     * @param templateRespVo
     * @return
     */
    PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 查询已匹配验收单数据列表
     *
     * @param respVo
     * @param templateRespVo
     * @return
     */
    PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 处理延迟收货查询验收单数据信息
     *
     * @param o
     * @param auditTemplateRespVo
     */
    void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo);
}