package com.biz.crm.finance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.nebular.kms.finance.req.KmsAcceptanceMatchRelationReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAcceptanceMatchRelationRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽核验收匹配关系表
 * 
 * @author Gavin
 * @date 2021-06-18 20:26:55
 */
public interface KmsAcceptanceMatchRelationMapper extends BaseMapper<KmsAcceptanceMatchRelationEntity> {
    /**
     * 列表
     * @param page
     * @param kmsAcceptanceMatchRelationReqVo
     * @return
     */
    List<KmsAcceptanceMatchRelationRespVo> findList(Page<KmsAcceptanceMatchRelationRespVo> page, @Param("vo") KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 通过验收单号查询稽核Id
     * @param reqVo
     * @return
     */
    List<KmsAcceptanceMatchRelationRespVo> findMatchList(@Param("vo") KmsAuditFormReqVo reqVo);
}
