package com.biz.crm.finance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽核数据
 * 
 * @author Gavin
 * @date 2021-05-27 11:09:31
 */
public interface KmsAuditFormMapper extends BaseMapper<KmsAuditFormEntity> {
    /**
     * 列表
     * @param page
     * @param kmsAuditFormReqVo
     * @return
     */
    List<KmsAuditFormRespVo> findList(Page<KmsAuditFormRespVo> page, @Param("vo") KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 查询模版下待匹配稽核数据信息
     * @param formReqVo
     * @return
     */
    List<KmsAuditFormRespVo> findList(@Param("vo") KmsAuditFormReqVo formReqVo);

    /**
     * 查询汇总信息
     * @param params
     * @return
     */
    KmsAuditFormEntity findByParams(@Param("vo") KmsAuditFormReqVo params);

    /**
     * 查询汇总信息
     * @param params
     * @return
     */
    List<KmsAuditFormEntity> findListByParams(@Param("vo") KmsAuditFormReqVo params);

    /**
     * 查询汇总信息
     * @param params
     * @return
     */
    List<KmsAuditFormRespVo> findRespListByParams(@Param("vo") KmsAuditFormReqVo formReqVo);

    /**
     * 汇总报表
     * @param page
     * @param kmsAuditFormReqVo
     * @return
     */
    List<KmsAuditFormRespVo> matchSummaryReport(Page<KmsAuditFormRespVo> page, @Param("vo") KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 稽核匹配汇总
     * @param params
     * @return
     */
    KmsAuditFormRespVo matchSummaryTotalCount(@Param("vo") KmsAuditFormReqVo params);
}
