package com.biz.crm.finance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.finance.model.KmsAuditTemplateEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽核模板
 * 
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
public interface KmsAuditTemplateMapper extends BaseMapper<KmsAuditTemplateEntity> {
    /**
     * 列表
     * @param page
     * @param kmsAuditTemplateReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsAuditTemplateRespVo> findList(Page<KmsAuditTemplateRespVo> page, @Param("vo") KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 列表
     * @param page
     * @param kmsAuditTemplateReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsAuditTemplateRespVo> findList(@Param("vo") KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 查询所有有效稽核模版
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsAuditTemplateRespVo> findAll(@Param("vo") KmsAuditTemplateReqVo templateReqVo);
}
