package com.biz.crm.finance.service;

import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.finance.resp.KmsAcceptanceMatchRelationRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAcceptanceMatchRelationReqVo;

import java.util.Map;

/**
 * 稽核验收匹配关系表接口
 *
 * @author Gavin
 * @date 2021-06-18 20:26:55
 */
public interface IKmsAcceptanceMatchRelationService extends IService<KmsAcceptanceMatchRelationEntity> {

    /**
     * 列表
     * @param kmsAcceptanceMatchRelationReqVo
     * @return PageResult<KmsAcceptanceMatchRelationRespVo>
     */
    PageResult<KmsAcceptanceMatchRelationRespVo> findList(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 查询
     * @param kmsAcceptanceMatchRelationReqVo
     * @return KmsAcceptanceMatchRelationRespVo
     */
    KmsAcceptanceMatchRelationRespVo query(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 新增
     * @param kmsAcceptanceMatchRelationReqVo
     * @return
     */
    void save(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 更新
     * @param kmsAcceptanceMatchRelationReqVo
     * @return
     */
    void update(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 删除
     * @param kmsAcceptanceMatchRelationReqVo
     * @return
     */
    void deleteBatch(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 启用
     * @param kmsAcceptanceMatchRelationReqVo
     * @return
     */
    void enableBatch(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);

    /**
     * 禁用
     * @param kmsAcceptanceMatchRelationReqVo
     * @return
     */
    void disableBatch(KmsAcceptanceMatchRelationReqVo kmsAcceptanceMatchRelationReqVo);
}

