package com.biz.crm.finance.service;

import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditMatchRelationRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditMatchRelationReqVo;

import java.util.Map;

/**
 * 稽核匹配关系表接口
 *
 * @author Gavin
 * @date 2021-05-27 15:14:19
 */
public interface IKmsAuditMatchRelationService extends IService<KmsAuditMatchRelationEntity> {

    /**
     * 列表
     * @param kmsAuditMatchRelationReqVo
     * @return PageResult<KmsAuditMatchRelationRespVo>
     */
    PageResult<KmsAuditMatchRelationRespVo> findList(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 查询
     * @param kmsAuditMatchRelationReqVo
     * @return KmsAuditMatchRelationRespVo
     */
    KmsAuditMatchRelationRespVo query(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 新增
     * @param kmsAuditMatchRelationReqVo
     * @return
     */
    void save(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 更新
     * @param kmsAuditMatchRelationReqVo
     * @return
     */
    void update(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 删除
     * @param kmsAuditMatchRelationReqVo
     * @return
     */
    void deleteBatch(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 启用
     * @param kmsAuditMatchRelationReqVo
     * @return
     */
    void enableBatch(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 禁用
     * @param kmsAuditMatchRelationReqVo
     * @return
     */
    void disableBatch(KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);
}

