package com.biz.crm.finance.service;

import com.biz.crm.finance.model.KmsAuditTemplateDirectEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateDirectReqVo;

import java.util.Map;

/**
 * 稽核模板商超信息接口
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
public interface IKmsAuditTemplateDirectService extends IService<KmsAuditTemplateDirectEntity> {

    /**
     * 列表
     * @param kmsAuditTemplateDirectReqVo
     * @return PageResult<KmsAuditTemplateDirectRespVo>
     */
    PageResult<KmsAuditTemplateDirectRespVo> findList(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 查询
     * @param kmsAuditTemplateDirectReqVo
     * @return KmsAuditTemplateDirectRespVo
     */
    KmsAuditTemplateDirectRespVo query(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 新增
     * @param kmsAuditTemplateDirectReqVo
     * @return
     */
    void save(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 更新
     * @param kmsAuditTemplateDirectReqVo
     * @return
     */
    void update(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 删除
     * @param kmsAuditTemplateDirectReqVo
     * @return
     */
    void deleteBatch(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 启用
     * @param kmsAuditTemplateDirectReqVo
     * @return
     */
    void enableBatch(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 禁用
     * @param kmsAuditTemplateDirectReqVo
     * @return
     */
    void disableBatch(KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);
}

