package com.biz.crm.grabrule.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 抓单规则配置表
 * 
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
public interface KmsGrabRuleMapper extends BaseMapper<KmsGrabRuleEntity> {
    /**
     * 列表
     * @param page
     * @param kmsGrabRuleReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsGrabRuleRespVo> findList(Page<KmsGrabRuleRespVo> page, @Param("vo") KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 查询抓单规则
     * @param param
     * @return
     */
    KmsGrabRuleRespVo findById(@Param("vo") KmsGrabRuleReqVo reqVo);
}
