package com.biz.crm.grabrule.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.grabrule.service.IKmsDataAuthService;
import com.biz.crm.nebular.kms.grabrule.req.KmsDataAuthReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsDataAuthRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 单据数据权限接口实现
 *
 * @author Gavin
 * @date 2021-05-10 15:03:52
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsDataAuthServiceExpandImpl")
public class KmsDataAuthServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsDataAuthMapper, KmsDataAuthEntity> implements IKmsDataAuthService {

    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsDataAuthRespVo> findList(KmsDataAuthReqVo reqVo){
        Page<KmsDataAuthRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsDataAuthRespVo> list = kmsDataAuthMapper.findList(page, reqVo);
        return PageResult.<KmsDataAuthRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsDataAuthRespVo
     */
    @Override
    public KmsDataAuthRespVo query(KmsDataAuthReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsDataAuthReqVo reqVo){
        KmsDataAuthEntity entity = CrmBeanUtil.copy(reqVo,KmsDataAuthEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsDataAuthReqVo reqVo){
        KmsDataAuthEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsDataAuthReqVo reqVo){
        List<KmsDataAuthEntity> kmsDataAuthEntities = kmsDataAuthMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsDataAuthEntities)){
            kmsDataAuthEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsDataAuthEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsDataAuthReqVo reqVo){
        //设置状态为启用
        List<KmsDataAuthEntity> kmsDataAuthEntities = kmsDataAuthMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsDataAuthEntities)){
            kmsDataAuthEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsDataAuthEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsDataAuthReqVo reqVo){
        //设置状态为禁用
        List<KmsDataAuthEntity> kmsDataAuthEntities = kmsDataAuthMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsDataAuthEntities)){
                kmsDataAuthEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsDataAuthEntities);
    }
}
