package com.biz.crm.kaproduct.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.kaproduct.service.IKmsTenantryDirectProductService;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductForExportRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 企业产品与商超产品关系
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Slf4j
@RestController
@RequestMapping("/tenantryDirectProduct")
@Api(tags = "企业产品与商超产品关系")
public class KmsTenantryDirectProductController {
    @Autowired
    private IKmsTenantryDirectProductService kmsTenantryDirectProductService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsTenantryDirectProductRespVo>> list(@RequestBody KmsTenantryDirectProductReqVo params) {
        PageResult<KmsTenantryDirectProductRespVo> result = kmsTenantryDirectProductService.findList(params);
        return Result.ok(result);
    }

    @ApiOperation("导出列表")
    @PostMapping("/listForExport")
    @CrmLog
    public Result<PageResult<KmsProductForExportRespVo>> listForExport(@RequestBody KmsTenantryDirectProductReqVo reqVo) {
        PageResult<KmsProductForExportRespVo> result = kmsTenantryDirectProductService.listForExport(reqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsTenantryDirectProductRespVo> query(@RequestBody KmsTenantryDirectProductReqVo params) {
        KmsTenantryDirectProductRespVo respVo = kmsTenantryDirectProductService.query(params);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsTenantryDirectProductReqVo params) {
        if (StringUtils.isEmpty(params.getId())) {
            kmsTenantryDirectProductService.save(params);
        } else {
            kmsTenantryDirectProductService.update(params);
        }
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsTenantryDirectProductReqVo params) {
        kmsTenantryDirectProductService.update(params);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsTenantryDirectProductService.deleteBatch(new KmsTenantryDirectProductReqVo().setIds(ids));
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsTenantryDirectProductService.enableBatch(new KmsTenantryDirectProductReqVo().setIds(ids));
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsTenantryDirectProductService.disableBatch(new KmsTenantryDirectProductReqVo().setIds(ids));
        return Result.ok("禁用成功");
    }
}
