package com.biz.crm.kaproduct.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.kaproduct.model.KmsProductUnitEntity;
import com.biz.crm.nebular.kms.kaproduct.req.KmsProductUnitReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductUnitRespVo;

/**
 * 企业产品与商超产品单位转换关系表
 * 
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
public interface KmsProductUnitMapper extends BaseMapper<KmsProductUnitEntity> {
    /**
     * 列表
     * @param page
     * @param kmsProductUnitReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsProductUnitRespVo> findList(Page<KmsProductUnitRespVo> page, @Param("vo") KmsProductUnitReqVo kmsProductUnitReqVo);

    //@SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsProductUnitRespVo> findList(@Param("vo") KmsProductUnitReqVo unitReqVo);
}
