package com.biz.crm.kaproduct.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductForExportRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;

/**
 * 企业产品与商超产品关系接口
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
public interface IKmsTenantryDirectProductService extends IService<KmsTenantryDirectProductEntity> {

    /**
     * 列表
     *
     * @param params
     * @return PageResult<KmsTenantryDirectProductRespVo>
     */
    PageResult<KmsTenantryDirectProductRespVo> findList(KmsTenantryDirectProductReqVo params);

    /**
     * 查询
     *
     * @param params
     * @return KmsTenantryDirectProductRespVo
     */
    KmsTenantryDirectProductRespVo query(KmsTenantryDirectProductReqVo params);

    /**
     * 新增
     *
     * @param params
     * @return
     */
    void save(KmsTenantryDirectProductReqVo params);

    /**
     * 更新
     *
     * @param params
     * @return
     */
    void update(KmsTenantryDirectProductReqVo params);

    /**
     * 删除
     *
     * @param params
     * @return
     */
    void deleteBatch(KmsTenantryDirectProductReqVo params);

    /**
     * 启用
     *
     * @param params
     * @return
     */
    void enableBatch(KmsTenantryDirectProductReqVo params);

    /**
     * 禁用
     *
     * @param params
     * @return
     */
    void disableBatch(KmsTenantryDirectProductReqVo params);

    /**
     * 列表导出
     *
     * @param reqVo
     * @return
     */
    PageResult<KmsProductForExportRespVo> listForExport(KmsTenantryDirectProductReqVo reqVo);
}

