package com.biz.crm.orderform.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderStatusRecordReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderStatusRecordRespVo;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderStatusRecordEntity;

import java.util.List;

/**
 * 商超订货单状态流转记录表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
public interface IKmsOrderStatusRecordService extends IService<KmsOrderStatusRecordEntity> {

    /**
     * 列表
     * @param kmsOrderStatusRecordReqVo
     * @return PageResult<KmsOrderStatusRecordRespVo>
     */
    PageResult<KmsOrderStatusRecordRespVo> findList(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    /**
     * 查询
     * @param kmsOrderStatusRecordReqVo
     * @return KmsOrderStatusRecordRespVo
     */
    KmsOrderStatusRecordRespVo query(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    /**
     * 新增
     * @param kmsOrderStatusRecordReqVo
     * @return
     */
    void save(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    /**
     * 更新
     * @param kmsOrderStatusRecordReqVo
     * @return
     */
    void update(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    /**
     * 删除
     * @param kmsOrderStatusRecordReqVo
     * @return
     */
    void deleteBatch(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    /**
     * 启用
     * @param kmsOrderStatusRecordReqVo
     * @return
     */
    void enableBatch(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    /**
     * 禁用
     * @param kmsOrderStatusRecordReqVo
     * @return
     */
    void disableBatch(KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

    void insert(List<KmsOrderFormEntity> orderFormEntities);

    void insert(KmsOrderFormEntity orderFormEntities);
}

