package com.biz.crm.orderform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.orderform.mapper.KmsOrderGoodsMapper;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.orderform.service.IKmsOrderGoodsService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 商超订货单商品表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsOrderGoodsServiceExpandImpl")
public class KmsOrderGoodsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsOrderGoodsMapper, KmsOrderGoodsEntity> implements IKmsOrderGoodsService {

    @Resource
    private KmsOrderGoodsMapper kmsOrderGoodsMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsOrderGoodsRespVo> findList(KmsOrderGoodsReqVo reqVo){
        Page<KmsOrderGoodsRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsOrderGoodsRespVo> list = kmsOrderGoodsMapper.findList(page, reqVo);
        return PageResult.<KmsOrderGoodsRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsOrderGoodsRespVo
     */
    @Override
    public KmsOrderGoodsRespVo query(KmsOrderGoodsReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsOrderGoodsReqVo reqVo){
        KmsOrderGoodsEntity entity = CrmBeanUtil.copy(reqVo,KmsOrderGoodsEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsOrderGoodsReqVo reqVo){
        KmsOrderGoodsEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsOrderGoodsReqVo reqVo){
        List<KmsOrderGoodsEntity> kmsOrderGoodsEntities = kmsOrderGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderGoodsEntities)){
            kmsOrderGoodsEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsOrderGoodsEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsOrderGoodsReqVo reqVo){
        //设置状态为启用
        List<KmsOrderGoodsEntity> kmsOrderGoodsEntities = kmsOrderGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderGoodsEntities)){
            kmsOrderGoodsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderGoodsEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsOrderGoodsReqVo reqVo){
        //设置状态为禁用
        List<KmsOrderGoodsEntity> kmsOrderGoodsEntities = kmsOrderGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderGoodsEntities)){
                kmsOrderGoodsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderGoodsEntities);
    }
}
