package com.biz.crm.rawdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.req.KmsReturnFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.rawdata.service.IKmsReturnFormDetailDwService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 退货单原始数据表
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@RestController
@RequestMapping("/kmsreturnformdetaildw")
//@Api(tags = "退货单原始数据表")
public class KmsReturnFormDetailDwController {
    @Autowired
    private IKmsReturnFormDetailDwService kmsReturnFormDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsReturnFormDetailDwRespVo>> list(@RequestBody KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        PageResult<KmsReturnFormDetailDwRespVo> result=kmsReturnFormDetailDwService.findList(kmsReturnFormDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsReturnFormDetailDwRespVo> query(@RequestBody KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        KmsReturnFormDetailDwRespVo respVo=kmsReturnFormDetailDwService.query(kmsReturnFormDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        kmsReturnFormDetailDwService.save(kmsReturnFormDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        kmsReturnFormDetailDwService.update(kmsReturnFormDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        kmsReturnFormDetailDwService.deleteBatch(kmsReturnFormDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        kmsReturnFormDetailDwService.enableBatch(kmsReturnFormDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo) {
        kmsReturnFormDetailDwService.disableBatch(kmsReturnFormDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
