package com.biz.crm.rawdata.service;

import com.biz.crm.rawdata.model.KmsOrderGoodsDetailDwEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderGoodsDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsOrderGoodsDetailDwReqVo;

import java.util.Map;

/**
 * 原单订单行数据信息接口
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
public interface IKmsOrderGoodsDetailDwService extends IService<KmsOrderGoodsDetailDwEntity> {

    /**
     * 列表
     * @param kmsOrderGoodsDetailDwReqVo
     * @return PageResult<KmsOrderGoodsDetailDwRespVo>
     */
    PageResult<KmsOrderGoodsDetailDwRespVo> findList(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);

    /**
     * 查询
     * @param kmsOrderGoodsDetailDwReqVo
     * @return KmsOrderGoodsDetailDwRespVo
     */
    KmsOrderGoodsDetailDwRespVo query(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);

    /**
     * 新增
     * @param kmsOrderGoodsDetailDwReqVo
     * @return
     */
    void save(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);

    /**
     * 更新
     * @param kmsOrderGoodsDetailDwReqVo
     * @return
     */
    void update(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);

    /**
     * 删除
     * @param kmsOrderGoodsDetailDwReqVo
     * @return
     */
    void deleteBatch(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);

    /**
     * 启用
     * @param kmsOrderGoodsDetailDwReqVo
     * @return
     */
    void enableBatch(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);

    /**
     * 禁用
     * @param kmsOrderGoodsDetailDwReqVo
     * @return
     */
    void disableBatch(KmsOrderGoodsDetailDwReqVo kmsOrderGoodsDetailDwReqVo);
}

