package com.biz.crm.rawdata.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.req.KmsReturnFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.rawdata.model.KmsReturnFormDetailDwEntity;

import java.util.List;

/**
 * 退货单原始数据表接口
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
public interface IKmsReturnFormDetailDwService extends IService<KmsReturnFormDetailDwEntity> {

    /**
     * 列表
     * @param kmsReturnFormDetailDwReqVo
     * @return PageResult<KmsReturnFormDetailDwRespVo>
     */
    PageResult<KmsReturnFormDetailDwRespVo> findList(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 查询
     * @param kmsReturnFormDetailDwReqVo
     * @return KmsReturnFormDetailDwRespVo
     */
    KmsReturnFormDetailDwRespVo query(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 新增
     * @param kmsReturnFormDetailDwReqVo
     * @return
     */
    void save(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 更新
     * @param kmsReturnFormDetailDwReqVo
     * @return
     */
    void update(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 删除
     * @param kmsReturnFormDetailDwReqVo
     * @return
     */
    void deleteBatch(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 启用
     * @param kmsReturnFormDetailDwReqVo
     * @return
     */
    void enableBatch(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 禁用
     * @param kmsReturnFormDetailDwReqVo
     * @return
     */
    void disableBatch(KmsReturnFormDetailDwReqVo kmsReturnFormDetailDwReqVo);

    /**
     * 查询待转换单据信息
     * @param params
     * @return
     */
    List<KmsReturnFormDetailDwRespVo> findNotTransData(KmsReturnFormDetailDwReqVo params);
}

