package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsSaleDataFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsSaleDataFormDetailDwMapper;
import com.biz.crm.rawdata.model.KmsSaleDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsSaleDataFormDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 库存商超原始单据接口实现
 *
 * @author gavin
 * @date 2021-11-24 14:17:12
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsSaleDataFormDetailDwServiceExpandImpl")
public class KmsSaleDataFormDetailDwServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<KmsSaleDataFormDetailDwMapper, KmsSaleDataFormDetailDwEntity> implements IKmsSaleDataFormDetailDwService {

    @Resource
    private KmsSaleDataFormDetailDwMapper kmsSaleDataFormDetailDwMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsSaleDataFormDetailDwRespVo> findList(KmsSaleDataFormDetailDwReqVo reqVo) {
        Page<KmsSaleDataFormDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsSaleDataFormDetailDwRespVo> list = kmsSaleDataFormDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsSaleDataFormDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return kmsSaleDataFormDetailDwRespVo
     */
    @Override
    public KmsSaleDataFormDetailDwRespVo query(KmsSaleDataFormDetailDwReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsSaleDataFormDetailDwReqVo reqVo) {
        KmsSaleDataFormDetailDwEntity entity = CrmBeanUtil.copy(reqVo, KmsSaleDataFormDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsSaleDataFormDetailDwReqVo reqVo) {
        KmsSaleDataFormDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsSaleDataFormDetailDwReqVo reqVo) {
        List<KmsSaleDataFormDetailDwEntity> kmsSaleDataFormDetailDwEntities = kmsSaleDataFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsSaleDataFormDetailDwEntities)) {
            kmsSaleDataFormDetailDwEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsSaleDataFormDetailDwEntities);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsSaleDataFormDetailDwReqVo reqVo) {
        //设置状态为启用
        List<KmsSaleDataFormDetailDwEntity> kmsSaleDataFormDetailDwEntities = kmsSaleDataFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsSaleDataFormDetailDwEntities)) {
            kmsSaleDataFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsSaleDataFormDetailDwEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsSaleDataFormDetailDwReqVo reqVo) {
        //设置状态为禁用
        List<KmsSaleDataFormDetailDwEntity> kmsSaleDataFormDetailDwEntities = kmsSaleDataFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsSaleDataFormDetailDwEntities)) {
            kmsSaleDataFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsSaleDataFormDetailDwEntities);
    }

    /**
     * 查询待转换单据信息
     *
     * @param params
     * @return
     */
    @Override
    public List<KmsSaleDataFormDetailDwRespVo> findNotTransData(KmsSaleDataFormDetailDwReqVo params) {
        return kmsSaleDataFormDetailDwMapper.findNotTransData(params);
    }
}
