package com.biz.crm.returnform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnFormReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormExportRespVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormRespVo;
import com.biz.crm.returnform.model.KmsReturnFormEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 退货单信息表
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
public interface KmsReturnFormMapper extends BaseMapper<KmsReturnFormEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsReturnFormReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsReturnFormRespVo> findList(Page<KmsReturnFormRespVo> page, @Param("vo") KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 导出列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsReturnFormExportRespVo> findListForExport(Page<KmsReturnFormExportRespVo> page, @Param("vo") KmsReturnFormReqVo reqVo);
}
