package com.biz.crm.returnform.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnStatusRecordReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnStatusRecordRespVo;
import com.biz.crm.returnform.model.KmsReturnFormEntity;
import com.biz.crm.returnform.model.KmsReturnStatusRecordEntity;

import java.util.List;

/**
 * 退货单状态记录表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
public interface IKmsReturnStatusRecordService extends IService<KmsReturnStatusRecordEntity> {

    /**
     * 列表
     * @param kmsReturnStatusRecordReqVo
     * @return PageResult<KmsReturnStatusRecordRespVo>
     */
    PageResult<KmsReturnStatusRecordRespVo> findList(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    /**
     * 查询
     * @param kmsReturnStatusRecordReqVo
     * @return KmsReturnStatusRecordRespVo
     */
    KmsReturnStatusRecordRespVo query(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    /**
     * 新增
     * @param kmsReturnStatusRecordReqVo
     * @return
     */
    void save(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    /**
     * 更新
     * @param kmsReturnStatusRecordReqVo
     * @return
     */
    void update(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    /**
     * 删除
     * @param kmsReturnStatusRecordReqVo
     * @return
     */
    void deleteBatch(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    /**
     * 启用
     * @param kmsReturnStatusRecordReqVo
     * @return
     */
    void enableBatch(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    /**
     * 禁用
     * @param kmsReturnStatusRecordReqVo
     * @return
     */
    void disableBatch(KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

    void insert(List<KmsReturnFormEntity> returnFormEntities);

    void insert(KmsReturnFormEntity returnFormEntity);
}

