package com.biz.crm.sap.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.sap.req.KmsSapInvoiceReqVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.service.IKmsSapInvoiceService;
import com.biz.crm.sap.service.IKmsSapOrderFormService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * SAP数据
 *
 * @author Gavin
 * @date 2021-05-27 14:34:14
 */
@Slf4j
@RestController
@RequestMapping("/kmssaporderform")
@Api(tags = "SAP数据")
public class KmsSapOrderFormController {
    @Autowired
    private IKmsSapOrderFormService kmsSapOrderFormService;

    @Autowired
    private IKmsSapInvoiceService kmsSapInvoiceService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsSapOrderFormRespVo>> list(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        PageResult<KmsSapOrderFormRespVo> result=kmsSapOrderFormService.findList(kmsSapOrderFormReqVo);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "SAP原始数据列表")
    @PostMapping("/sap/invoicePage")
    @CrmLog
    public Result<PageResult<KmsSapInvoiceRespVo>> findSapInvoicePage(@RequestBody KmsSapInvoiceReqVo params) {
        PageResult<KmsSapInvoiceRespVo> result=kmsSapInvoiceService.findSapInvoicePage(params);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsSapOrderFormRespVo> query(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        KmsSapOrderFormRespVo respVo=kmsSapOrderFormService.query(kmsSapOrderFormReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        kmsSapOrderFormService.save(kmsSapOrderFormReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        kmsSapOrderFormService.update(kmsSapOrderFormReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        kmsSapOrderFormService.deleteBatch(kmsSapOrderFormReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        kmsSapOrderFormService.enableBatch(kmsSapOrderFormReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        kmsSapOrderFormService.disableBatch(kmsSapOrderFormReqVo);
        return Result.ok("禁用成功");
    }
}
