package com.biz.crm.stockdata.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.stockdata.req.KmsStockDataReqVo;
import com.biz.crm.nebular.kms.stockdata.resp.KmsStockDataRespVo;
import com.biz.crm.stockdata.model.KmsStockDataEntity;

import java.util.List;

/**
 * 库存数据表接口
 *
 * @author gavin
 * @date 2021-11-24 14:22:01
 */
public interface IKmsStockDataService extends IService<KmsStockDataEntity> {

    /**
     * 列表
     *
     * @param kmsStockDataReqVo
     * @return PageResult<KmsStockDataRespVo>
     */
    PageResult<KmsStockDataRespVo> findList(KmsStockDataReqVo kmsStockDataReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsStockDataRespVo
     */
    KmsStockDataRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsStockDataReqVo
     * @return
     */
    void save(KmsStockDataReqVo kmsStockDataReqVo);

    /**
     * 更新
     *
     * @param kmsStockDataReqVo
     * @return
     */
    void update(KmsStockDataReqVo kmsStockDataReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param kmsStockDataReqVo
     * @return
     */
    void enableBatch(KmsStockDataReqVo kmsStockDataReqVo);

    /**
     * 禁用
     *
     * @param kmsStockDataReqVo
     * @return
     */
    void disableBatch(KmsStockDataReqVo kmsStockDataReqVo);

    /**
     * 自动转换库存数据
     *
     * @param o
     */
    void autoTransData(KmsInventoryDataFormDetailDwRespVo o);

    /**
     * 手动转换库存数据
     *
     * @param kmsStockDataReqVo
     */
    void manualTrans(KmsStockDataReqVo kmsStockDataReqVo);
}

