package com.biz.crm.supermarket.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsSupplierReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsSupplierRespVo;
import com.biz.crm.supermarket.service.IKmsSupplierService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 售达方与供应商关系表
 *
 * @author gavin
 * @date 2021-07-06 13:58:17
 */
@Slf4j
@RestController
@RequestMapping("/kmssupplier")
@Api(tags = "售达方与供应商关系表")
public class KmsSupplierController {
    @Autowired
    private IKmsSupplierService kmsSupplierService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsSupplierRespVo>> list(@RequestBody KmsSupplierReqVo kmsSupplierReqVo) {
        PageResult<KmsSupplierRespVo> result=kmsSupplierService.findList(kmsSupplierReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsSupplierRespVo> query(@RequestBody KmsSupplierReqVo kmsSupplierReqVo) {
        KmsSupplierRespVo respVo=kmsSupplierService.query(kmsSupplierReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsSupplierReqVo kmsSupplierReqVo) {
        kmsSupplierService.save(kmsSupplierReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsSupplierReqVo kmsSupplierReqVo) {
        kmsSupplierService.update(kmsSupplierReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        KmsSupplierReqVo kmsSupplierReqVo = new KmsSupplierReqVo();
        kmsSupplierReqVo.setIds(ids);
        kmsSupplierService.deleteBatch(kmsSupplierReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        KmsSupplierReqVo kmsSupplierReqVo = new KmsSupplierReqVo();
        kmsSupplierReqVo.setIds(ids);
        kmsSupplierService.enableBatch(kmsSupplierReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        KmsSupplierReqVo kmsSupplierReqVo = new KmsSupplierReqVo();
        kmsSupplierReqVo.setIds(ids);
        kmsSupplierService.disableBatch(kmsSupplierReqVo);
        return Result.ok("禁用成功");
    }
}
