package com.biz.crm.supermarket.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectAccountReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectAccountRespVo;
import com.biz.crm.supermarket.service.IKmsTenantryDirectAccountService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 抓单账号管理
 *
 * @author Gavin
 * @date 2021-04-13 23:19:46
 */
@Slf4j
@RestController
@RequestMapping("/kmstenantrydirectaccount")
@Api(tags = "抓单账号管理")
public class KmsTenantryDirectAccountController {
    @Autowired
    private IKmsTenantryDirectAccountService kmsTenantryDirectAccountService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsTenantryDirectAccountRespVo>> list(@RequestBody KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo) {
        PageResult<KmsTenantryDirectAccountRespVo> result = kmsTenantryDirectAccountService.findList(kmsTenantryDirectAccountReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<KmsTenantryDirectAccountRespVo> query(@RequestParam(value = "id", required = false) String id) {
        KmsTenantryDirectAccountRespVo respVo = kmsTenantryDirectAccountService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo) {
        kmsTenantryDirectAccountService.save(kmsTenantryDirectAccountReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo) {
        kmsTenantryDirectAccountService.update(kmsTenantryDirectAccountReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsTenantryDirectAccountService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsTenantryDirectAccountService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsTenantryDirectAccountService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
