package com.biz.crm.supermarket.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业门店与商超门店关系
 *
 * @author Gavin
 * @date 2021-04-15 11:31:07
 */
public interface KmsTenantryDirectStoreMapper extends BaseMapper<KmsTenantryDirectStoreEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsTenantryDirectStoreReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectStoreRespVo> findList(Page<KmsTenantryDirectStoreRespVo> page, @Param("vo") KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo);

    /**
     * 查询企业门店与商超门店对应关系
     *
     * @param directStoreReqVo
     * @return
     */
    List<KmsTenantryDirectStoreRespVo> findList(@Param("vo") KmsTenantryDirectStoreReqVo directStoreReqVo);

    /**
     * 条件查询 （检验存在）
     * 数据权限
     *
     * @param storeReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectStoreEntity> selectListByCompetenceForExist(@Param("vo") KmsTenantryDirectStoreReqVo storeReqVo);

    /**
     * 查询商超门店信息
     * @param directStoreReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectStoreRespVo> findStoreAndArea(@Param("vo") KmsTenantryDirectStoreReqVo directStoreReqVo);

    /**
     * 通过id更新
     */
    void updateByKey(@Param("vo")KmsTenantryDirectStoreEntity vo);
}
