package com.biz.crm.supermarket.service;

import com.biz.crm.supermarket.model.KmsSupplierEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.supermarket.resp.KmsSupplierRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsSupplierReqVo;

import java.util.Map;

/**
 * 售达方与供应商关系表接口
 *
 * @author gavin
 * @date 2021-07-06 13:58:17
 */
public interface IKmsSupplierService extends IService<KmsSupplierEntity> {

    /**
     * 列表
     * @param kmsSupplierReqVo
     * @return PageResult<KmsSupplierRespVo>
     */
    PageResult<KmsSupplierRespVo> findList(KmsSupplierReqVo kmsSupplierReqVo);

    /**
     * 查询
     * @param kmsSupplierReqVo
     * @return KmsSupplierRespVo
     */
    KmsSupplierRespVo query(KmsSupplierReqVo kmsSupplierReqVo);

    /**
     * 新增
     * @param kmsSupplierReqVo
     * @return
     */
    void save(KmsSupplierReqVo kmsSupplierReqVo);

    /**
     * 更新
     * @param kmsSupplierReqVo
     * @return
     */
    void update(KmsSupplierReqVo kmsSupplierReqVo);

    /**
     * 删除
     * @param kmsSupplierReqVo
     * @return
     */
    void deleteBatch(KmsSupplierReqVo kmsSupplierReqVo);

    /**
     * 启用
     * @param kmsSupplierReqVo
     * @return
     */
    void enableBatch(KmsSupplierReqVo kmsSupplierReqVo);

    /**
     * 禁用
     * @param kmsSupplierReqVo
     * @return
     */
    void disableBatch(KmsSupplierReqVo kmsSupplierReqVo);
}

