package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectAccountReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectAccountRespVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectAccountService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抓单账号管理接口实现
 *
 * @author Gavin
 * @date 2021-04-13 23:19:46
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsTenantryDirectAccountServiceExpandImpl")
public class KmsTenantryDirectAccountServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<KmsTenantryDirectAccountMapper, KmsTenantryDirectAccountEntity> implements IKmsTenantryDirectAccountService {

    @Resource
    private KmsTenantryDirectAccountMapper kmsTenantryDirectAccountMapper;

    @Resource
    private KmsTenantryDirectHelper helper;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsTenantryDirectAccountRespVo> findList(KmsTenantryDirectAccountReqVo reqVo) {
        Page<KmsTenantryDirectAccountRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsTenantryDirectAccountRespVo> list = kmsTenantryDirectAccountMapper.findList(page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            helper.convertAccountDate(list);
        }
        return PageResult.<KmsTenantryDirectAccountRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 查询
     *
     * @param id
     * @return kmsTenantryDirectAccountRespVo
     */
    @Override
    public KmsTenantryDirectAccountRespVo query(String id) {
        AssertUtils.isNotEmpty(id, CommonException.IDS_NULL);
        KmsTenantryDirectAccountReqVo reqVo = new KmsTenantryDirectAccountReqVo();
        reqVo.setId(id);
        List<KmsTenantryDirectAccountRespVo> list = this.findList(reqVo).getData();
        AssertUtils.isNotEmpty(list, "查询数据不存在");
        return list.get(0);
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsTenantryDirectAccountReqVo reqVo) {
        helper.checkSaveAccountData(reqVo);
        KmsTenantryDirectAccountEntity entity = CrmBeanUtil.copy(reqVo, KmsTenantryDirectAccountEntity.class);
        this.save(entity);
        KmsTenantryDirectAccountRespVo newData = CrmBeanUtil.copy(entity, KmsTenantryDirectAccountRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getLoginAcc(), newData);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsTenantryDirectAccountReqVo reqVo) {
        helper.checkAccountUpdate(reqVo);
        helper.checkSaveAccountData(reqVo);
        KmsTenantryDirectAccountEntity entity = CrmBeanUtil.copy(reqVo, KmsTenantryDirectAccountEntity.class);
        KmsTenantryDirectAccountRespVo oldData = this.query(reqVo.getId());
        this.updateById(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        KmsTenantryDirectAccountRespVo newData = this.query(reqVo.getId());
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getLoginAcc(), oldData, newData);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<KmsTenantryDirectAccountEntity> kmsTenantryDirectAccountEntities = kmsTenantryDirectAccountMapper
                .selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(kmsTenantryDirectAccountEntities)) {
            kmsTenantryDirectAccountEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsTenantryDirectAccountEntities);
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        //设置状态为启用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<KmsTenantryDirectAccountEntity> kmsTenantryDirectAccountEntities = kmsTenantryDirectAccountMapper
                .selectBatchIds(ids);
        List<KmsTenantryDirectAccountRespVo> oldData = CrmBeanUtil
                .copyList(kmsTenantryDirectAccountEntities, KmsTenantryDirectAccountRespVo.class);
        if (CollectionUtils.isNotEmpty(kmsTenantryDirectAccountEntities)) {
            kmsTenantryDirectAccountEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsTenantryDirectAccountEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<KmsTenantryDirectAccountRespVo> newData = CrmBeanUtil.copyList(kmsTenantryDirectAccountEntities, KmsTenantryDirectAccountRespVo.class);
        for (int n = 0; n < newData.size(); n++) {
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.get(n).getId(), newData.get(n).getLoginAcc(), oldData.get(n), newData.get(n));
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<KmsTenantryDirectAccountEntity> kmsTenantryDirectAccountEntities = kmsTenantryDirectAccountMapper
                .selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(kmsTenantryDirectAccountEntities)) {
            kmsTenantryDirectAccountEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsTenantryDirectAccountEntities);
    }
}
