package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.KmsSapConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.sql.*;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName JDBCUtils
 * @Author Gavin
 * @Date 2021/6/1 下午4:07
 * @Description 原生jdbc连接hana
 */
@Slf4j
@Component
public class JDBCUtils {

    private static String drivername = "com.sap.db.jdbc.Driver";

    @Resource
    private KmsSapConfig kmsSapConfig;

    private static final JDBCUtils instance = new JDBCUtils();

    @PostConstruct
    public void init(){
        instance.kmsSapConfig = kmsSapConfig;
    }

    /**
     * 获取数据库连接对象
     * @return
     */
    public static Connection getConnection() {
        Connection con = null;
        try {
            con = DriverManager.getConnection(instance.kmsSapConfig.getSapHanaAddr(),
                    instance.kmsSapConfig.getSapHanaUserName(),
                    instance.kmsSapConfig.getSapHanaPassWord());
        } catch (SQLException e) {
            log.info("hana数据库连接异常:{}",e.getMessage());
            throw new BusinessException("hana数据库连接异常，" + e.getMessage());
        }
        return con;
    }

    /**
     * 关闭JDBC相关资源
     * @param con
     * @param sta
     * @param rs
     */
    public static void closeResource(Connection con, Statement sta, ResultSet rs) {
        try {
            if(con!=null) {
                con.close();
            }
            if(sta!=null) {
                sta.close();
            }
            if(rs!=null) {
                rs.close();
            }
        } catch (SQLException e) {
            log.info("关闭异常：{}",e.getMessage());
        }
    }
}