package com.biz.crm.webservice.order.req;

import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import lombok.Builder;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.webservice.data
 * @ClassName KmsSapOrderItmeVo
 * @Author Gavin
 * @Date 2021/5/28 下午1:59
 * @Description
 */
@XmlRootElement
public class KmsSapOrderItmeVo {

    @XmlElement(name = "item")
    private List<KmsSapOrderItmeDataVo> itmeDataVos = Lists.newArrayList();

    @XmlTransient
    public List<KmsSapOrderItmeDataVo> getItmeDataVos() {
        return itmeDataVos;
    }

    public void setItmeDataVos(List<KmsSapOrderItmeDataVo> itmeDataVos) {
        this.itmeDataVos = itmeDataVos;
    }

    public KmsSapOrderItmeVo(){
        super();
    }

    @Builder
    public KmsSapOrderItmeVo(KmsOrderFormRespVo kmsOrderFormRespVo){
        List<KmsSapOrderItmeDataVo> itmeDataVos = Lists.newArrayList();
        kmsOrderFormRespVo.getGoodsVos().forEach(o -> {
            //物料号 KMS-单据展示-订单-企业产品编号
            if(!StringUtils.isEmpty(o.getGoodsCode()) && !StringUtils.isEmpty(o.getCurCompanyUnitOrderQuantity())
                    && !StringUtils.isEmpty(o.getCurCompanyUnit())){
                itmeDataVos.add(KmsSapOrderItmeDataVo.builder().header(kmsOrderFormRespVo).item(o).build());
            }
        });
        this.itmeDataVos = itmeDataVos;
    }
}