package com.biz.crm.acceptanceform.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Resource;
import javax.xml.soap.SOAPException;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.confadmin.model.KmsDirectStoreAreaEntity;
import com.biz.crm.confadmin.service.IKmsDirectStoreAreaService;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.cxf.interceptor.Fault;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acceptanceform.helper.KmsAcceptanceFormHelper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceGoodsMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceFormService;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceGoodsService;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.finance.mapper.KmsAcceptanceMatchRelationMapper;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormExportRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceGoodsRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAcceptanceMatchRelationRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsAcceptanceFormDetailDwMapper;
import com.biz.crm.rawdata.mapper.KmsAcceptanceGoodsDetailDwMapper;
import com.biz.crm.rawdata.model.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * 转换后验收单接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsAcceptanceFormServiceExpandImpl")
public class KmsAcceptanceFormServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<KmsAcceptanceFormMapper, KmsAcceptanceFormEntity> implements IKmsAcceptanceFormService {

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private KmsAcceptanceGoodsMapper kmsAcceptanceGoodsMapper;

    @Resource
    private IKmsAcceptanceGoodsService kmsAcceptanceGoodsService;

    @Resource
    private KmsAcceptanceFormHelper kmsAcceptanceFormHelper;

    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;

    @Resource
    private KmsAcceptanceMatchRelationMapper kmsAcceptanceMatchRelationMapper;

    @Resource
    private IKmsAuditFormService kmsAuditFormService;

    @Resource
    private KmsAcceptanceFormDetailDwMapper kmsAcceptanceFormDetailDwMapper;

    @Resource
    private KmsAcceptanceGoodsDetailDwMapper kmsAcceptanceGoodsDetailDwMapper;

    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;

    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;

    @Resource
    private IKmsDirectStoreAreaService kmsDirectStoreAreaService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAcceptanceFormRespVo> findList(KmsAcceptanceFormReqVo reqVo) {
        if (com.biz.crm.util.StringUtils.isNotEmpty(reqVo.getCompanyOrgCode())){
            List<MdmOrgRespVo> childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf(reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty(childrenOrgListIncludeSelf)) {
                throw new Fault(new SOAPException("公司代码错误，企业组织查询不到相关信息"));
            }
            List<String> orgCodes = childrenOrgListIncludeSelf.stream()
                    .map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        Page<KmsAcceptanceFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAcceptanceFormRespVo> list = kmsAcceptanceFormMapper.findList(page, reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            List<String> orderNumber = list.stream().map(KmsAcceptanceFormRespVo::getOrderNumber).collect(Collectors.toList());
            List<KmsAcceptanceGoodsEntity> goodsEntities = kmsAcceptanceGoodsService.lambdaQuery()
                    .in(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber).list();
            Map<String, List<KmsAcceptanceGoodsEntity>> goodsMap = goodsEntities.stream()
                    .collect(Collectors.groupingBy(KmsAcceptanceGoodsEntity::getOrderNumber));
            //查询当前创建者所属公司
            List<String> createOrgCodes = list.stream().map(KmsAcceptanceFormRespVo::getCreateOrgCode)
                    .distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            //区域名称
            List<String> ids = list.stream().map(KmsAcceptanceFormRespVo::getStoreRelatedId).distinct().collect(Collectors.toList());
            List<KmsAcceptanceFormRespVo> nameList = kmsAcceptanceFormMapper.findAreaName(ids);
            Map<String, List<KmsAcceptanceFormRespVo>> nameMap = nameList.stream()
                    .collect(Collectors.groupingBy(KmsAcceptanceFormRespVo::getId));
            this.setData(list,goodsMap,orgCompanyMap,nameMap);
        }
        return PageResult.<KmsAcceptanceFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 导出列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAcceptanceFormExportRespVo> listForExport(KmsAcceptanceFormReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAcceptanceDateStart(),"验收开始日期不能为空");
        AssertUtils.isNotEmpty(reqVo.getAcceptanceDateEnd(),"验收结束日期不能为空");
        if (com.biz.crm.util.StringUtils.isNotEmpty(reqVo.getCompanyOrgCode())){
            List<MdmOrgRespVo> childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf(reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty(childrenOrgListIncludeSelf)) {
                throw new Fault(new SOAPException("公司代码错误，企业组织查询不到相关信息"));
            }
            List<String> orgCodes = childrenOrgListIncludeSelf.stream()
                    .map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        Page<KmsAcceptanceFormExportRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAcceptanceFormExportRespVo> list = kmsAcceptanceFormMapper.findListForExport(page, reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            List<String> orderNumber = list.stream().map(KmsAcceptanceFormRespVo::getOrderNumber).collect(Collectors.toList());
            List<KmsAcceptanceGoodsEntity> goodsEntities = kmsAcceptanceGoodsService.lambdaQuery()
                    .in(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber).list();
            Map<String, List<KmsAcceptanceGoodsEntity>> goodsMap = goodsEntities.stream()
                    .collect(Collectors.groupingBy(KmsAcceptanceGoodsEntity::getOrderNumber));
            //查询当前创建者所属公司
            List<String> createOrgCodes = list.stream().map(KmsAcceptanceFormRespVo::getCreateOrgCode)
                    .distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> {
                o.setFinalAcceptanceAmount(BigDecimal.ZERO.toString());
                List<KmsAcceptanceGoodsEntity> entities = goodsMap.get(o.getOrderNumber());
                if (!org.springframework.util.CollectionUtils.isEmpty(entities)) {
                    entities.forEach(e -> {
                        if (!StringUtils.isEmpty(e.getAcceptanceAmount())) {
                            o.setFinalAcceptanceAmount(new BigDecimal(o.getFinalAcceptanceAmount())
                                    .add(new BigDecimal(e.getAcceptanceAmount())).toString());
                        }
                    });
                }
                o.setOwnedCompany(orgCompanyMap.get(o.getCreateOrgCode()));
            });
        }
        return PageResult.<KmsAcceptanceFormExportRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return kmsAcceptanceFormRespVo
     */
    @Override
    public KmsAcceptanceFormRespVo query(KmsAcceptanceFormReqVo reqVo) {
        String id = reqVo.getId();
        AssertUtils.isNotEmpty(id, "单据ID不能为空");
        KmsAcceptanceFormEntity acceptanceFormEntity = kmsAcceptanceFormMapper.selectById(id);
        AssertUtils.isNotNull(acceptanceFormEntity, "未查询到数据信息");
        KmsAcceptanceFormRespVo formRespVo = CrmBeanUtil.copy(acceptanceFormEntity, KmsAcceptanceFormRespVo.class);
        String orderNumber = formRespVo.getOrderNumber();
        //查询商品行信息
        LambdaQueryWrapper<KmsAcceptanceGoodsEntity> build = new LambdaQueryWrapper<KmsAcceptanceGoodsEntity>()
                .eq(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber);
        List<KmsAcceptanceGoodsEntity> goodsEntities = kmsAcceptanceGoodsMapper.selectList(build);
        formRespVo.setAcceptanceGoodsVos(CrmBeanUtil.copyList(goodsEntities, KmsAcceptanceGoodsRespVo.class));
        return formRespVo;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAcceptanceFormReqVo reqVo) {
        KmsAcceptanceFormEntity entity = CrmBeanUtil.copy(reqVo, KmsAcceptanceFormEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAcceptanceFormReqVo reqVo) {
        KmsAcceptanceFormEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAcceptanceFormReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getIds(), CommonException.IDS_NULL.getDescription());
        List<KmsAcceptanceFormEntity> kmsAcceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(reqVo.getIds());
        List<KmsAcceptanceFormDetailDwEntity> kmsAcceptanceFormDetailDwEntities = kmsAcceptanceFormDetailDwMapper
                .selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isEmpty(kmsAcceptanceFormEntities)) {
            return;
        }
        Set<String> orderNumberSet = kmsAcceptanceFormEntities.stream()
                .map(KmsAcceptanceFormEntity::getOrderNumber).collect(Collectors.toSet());
        this.removeByIds(orderNumberSet);
        kmsAcceptanceFormDetailDwMapper.deleteBatchIds(orderNumberSet);
        if (CollectionUtils.isEmpty(orderNumberSet)) {
            return;
        }
        List<KmsAcceptanceGoodsEntity> kmsAcceptanceGoodsEntities = kmsAcceptanceGoodsMapper
                .selectList(Wrappers.<KmsAcceptanceGoodsEntity>lambdaQuery()
                        .in(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumberSet));
        List<KmsAcceptanceGoodsDetailDwEntity> kmsAcceptanceGoodsDetailDwEntities = kmsAcceptanceGoodsDetailDwMapper
                .selectList(Wrappers.<KmsAcceptanceGoodsDetailDwEntity>lambdaQuery()
                        .in(KmsAcceptanceGoodsDetailDwEntity::getOrderNumber, orderNumberSet));
        if (CollectionUtils.isNotEmpty(kmsAcceptanceGoodsEntities)) {
            kmsAcceptanceGoodsMapper.deleteBatchIds(kmsAcceptanceGoodsEntities.stream()
                    .map(KmsAcceptanceGoodsEntity::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(kmsAcceptanceGoodsDetailDwEntities)) {
            kmsAcceptanceGoodsDetailDwMapper.deleteBatchIds(kmsAcceptanceGoodsDetailDwEntities.stream()
                    .map(KmsAcceptanceGoodsDetailDwEntity::getId).collect(Collectors.toSet()));
        }
        KmsAuditFormReqVo kmsAuditFormReqVo = new KmsAuditFormReqVo();
        kmsAuditFormReqVo.setAcceptanceComNumberList(Lists.newArrayList(orderNumberSet));
        List<KmsAcceptanceMatchRelationRespVo> mapperMatchList = kmsAcceptanceMatchRelationMapper.findMatchList(kmsAuditFormReqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(mapperMatchList)) {
            //刷新稽核结果
            List<String> auditIds = mapperMatchList.stream()
                    .map(KmsAcceptanceMatchRelationRespVo::getAuditId)
                    .collect(Collectors.toList());
            KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
            formReqVo.setIds(auditIds);
            kmsAuditFormService.refreshAuditResult(formReqVo);
            Set<String> relationIds = mapperMatchList.stream()
                    .map(KmsAcceptanceMatchRelationRespVo::getId).collect(Collectors.toSet());
            kmsAcceptanceMatchRelationMapper.deleteBatchIds(relationIds);
        }
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAcceptanceFormReqVo reqVo) {
        //设置状态为启用
        List<KmsAcceptanceFormEntity> kmsAcceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsAcceptanceFormEntities)) {
            kmsAcceptanceFormEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceFormEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAcceptanceFormReqVo reqVo) {
        //设置状态为禁用
        List<KmsAcceptanceFormEntity> kmsAcceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsAcceptanceFormEntities)) {
            kmsAcceptanceFormEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceFormEntities);
    }

    /**
     * 手动转换验收单
     *
     * @param kmsAcceptanceFormReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void manualTrans(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        List<String> ids = kmsAcceptanceFormReqVo.getIds();
        AssertUtils.isNotEmpty(ids, "请选择待转换数据");
        //查询验收单状态，待确认、转换失败
        List<KmsAcceptanceFormEntity> acceptanceFormEntities = this.lambdaQuery()
                .in(KmsAcceptanceFormEntity::getId, ids).list();
        List<KmsAcceptanceFormDetailDwRespVo> detailDwRespVos = CrmBeanUtil.copyList(acceptanceFormEntities, KmsAcceptanceFormDetailDwRespVo.class);
        detailDwRespVos.forEach(dwRespVo -> {
            //匹配处理验收单版本信息
            KmsAcceptanceFormEntity acceptanceFormEntity = kmsAcceptanceFormHelper.transFormVersion(dwRespVo);
            if (!ObjectUtils.isEmpty(acceptanceFormEntity)) {
                //匹配处理验收单商品详情新版本数据
                List<KmsAcceptanceGoodsEntity> goodsEntities = kmsAcceptanceFormHelper.transGoodsVersion(acceptanceFormEntity);
                //数据转换
                kmsAcceptanceFormHelper.transData(acceptanceFormEntity, goodsEntities);
                //保存验收单头信息
                this.saveOrUpdate(acceptanceFormEntity);
                //保存验收单商品行信息
                kmsAcceptanceGoodsService.saveOrUpdateBatch(goodsEntities);
                //保存订单状态记录表
                kmsAcceptanceStatusRecordService.insert(acceptanceFormEntity);
                //查询验收单是否已参与匹配
                KmsAuditFormReqVo reqVo = new KmsAuditFormReqVo();
                reqVo.setAcceptanceComNumberList(acceptanceFormEntities.stream()
                        .map(KmsAcceptanceFormEntity::getOrderNumber).distinct().collect(Collectors.toList()));
                List<KmsAcceptanceMatchRelationRespVo> mapperMatchList = kmsAcceptanceMatchRelationMapper.findMatchList(reqVo);
                if (!org.springframework.util.CollectionUtils.isEmpty(mapperMatchList)) {
                    //刷新稽核结果
                    List<String> auditIds = mapperMatchList.stream()
                            .map(KmsAcceptanceMatchRelationRespVo::getAuditId)
                            .collect(Collectors.toList());
                    KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
                    formReqVo.setIds(auditIds);
                    kmsAuditFormService.refreshAuditResult(formReqVo);
                }
            }
        });
    }

    /**
     * 自动转换验收单
     *
     * @param dwRespVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoTransData(KmsAcceptanceFormDetailDwRespVo dwRespVo) {
        //匹配处理验收单版本信息
        KmsAcceptanceFormEntity acceptanceFormEntity = kmsAcceptanceFormHelper.transFormVersion(dwRespVo);
        if (!ObjectUtils.isEmpty(acceptanceFormEntity)) {
            //匹配处理验收单商品详情新版本数据
            List<KmsAcceptanceGoodsEntity> goodsEntities = kmsAcceptanceFormHelper.transGoodsVersion(acceptanceFormEntity);
            //数据转换
            kmsAcceptanceFormHelper.transData(acceptanceFormEntity, goodsEntities);
            //保存验收单头信息
            this.saveOrUpdate(acceptanceFormEntity);
            //保存验收单商品行信息
            kmsAcceptanceGoodsService.saveOrUpdateBatch(goodsEntities);
            //保存订单状态记录表
            kmsAcceptanceStatusRecordService.insert(acceptanceFormEntity);
        }
    }

    /**
     * 稽核匹配
     * @param orderNumber
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void auditMatch(String orderNumber) {
        KmsAcceptanceFormEntity acceptanceFormEntity = this.lambdaQuery()
                .eq(KmsAcceptanceFormEntity::getOrderNumber,orderNumber).one();
        AssertUtils.isNotNull(acceptanceFormEntity, "未查询到数据信息");
        if(!KmsEnum.OrderStatus.S400.getValue().equals(acceptanceFormEntity.getOrderStatus())){
            return;
        }
        //查询商品行信息
        LambdaQueryWrapper<KmsAcceptanceGoodsEntity> build = new LambdaQueryWrapper<KmsAcceptanceGoodsEntity>()
                .eq(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber);
        List<KmsAcceptanceGoodsEntity> goodsEntities = kmsAcceptanceGoodsMapper.selectList(build);
        List<String> goodsCodes = goodsEntities.stream()
                .filter(o -> !StringUtils.isEmpty(o.getGoodsCode()))
                .map(KmsAcceptanceGoodsEntity::getGoodsCode)
                .collect(Collectors.toList());
        //商超+时间+商品+门店/售达方查询稽核单据
        KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
        formReqVo.setBsDirectSystemId(acceptanceFormEntity.getBsDirectSystemId());
        if(!StringUtils.isEmpty(acceptanceFormEntity.getAuditDate())){
            Date dateByFormat = DateUtil.getDateByFormat(acceptanceFormEntity.getAuditDate(), DateUtil.DEFAULT_DAY_PATTERN);
            String sapPostingDate = DateUtil.format(dateByFormat, DateUtil.DEFAULT_MONTH_DAY_PATTERN);
            formReqVo.setSapPostingDate(sapPostingDate);
            formReqVo.setSapMaterielCodeList(goodsCodes);
            List<KmsAuditFormRespVo> auditFormRespVos = kmsAuditFormMapper.findRespListByParams(formReqVo);
            auditFormRespVos.forEach(o -> {
                KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
                templateReqVo.setId(o.getAuditTemplateId());
                templateReqVo.setBsDirectSystemId(o.getBsDirectSystemId());
                List<KmsAuditTemplateRespVo> auditTemplateRespVos = kmsAuditTemplateService.findAll(templateReqVo);
                if(!org.springframework.util.CollectionUtils.isEmpty(auditTemplateRespVos)){
                    KmsAuditTemplateRespVo auditTemplateRespVo = auditTemplateRespVos.get(0);
                    List<KmsAuditTemplateDirectRespVo> directVos = auditTemplateRespVo.getDirectVos();
                    if(!org.springframework.util.CollectionUtils.isEmpty(directVos)){
                        kmsAuditFormService.auditMatch(o,auditTemplateRespVo);
                        try {
                            //处理延迟收货
                            o.setRemarks("延迟收货");
                            kmsAuditFormService.delayedReceipt(o, auditTemplateRespVo);
                        }catch (Exception e){
                            log.info("延迟收货处理异常：{}",e.getMessage());
                        }
                    }
                }
            });
        }
    }

    public void setData(List<KmsAcceptanceFormRespVo> list,Map<String, List<KmsAcceptanceGoodsEntity>> goodsMap,Map<String, String> orgCompanyMap,Map<String, List<KmsAcceptanceFormRespVo>> areaNameMap){
        list.forEach(o -> {
            o.setFinalAcceptanceAmount(BigDecimal.ZERO.toString());
            List<KmsAcceptanceGoodsEntity> entities = goodsMap.get(o.getOrderNumber());
            if (!org.springframework.util.CollectionUtils.isEmpty(entities)) {
                entities.forEach(e -> {
                    if (!StringUtils.isEmpty(e.getAcceptanceAmount())) {
                        o.setFinalAcceptanceAmount(new BigDecimal(o.getFinalAcceptanceAmount())
                                .add(new BigDecimal(e.getAcceptanceAmount())).toString());
                    }
                });
            }
            o.setOwnedCompany(orgCompanyMap.get(o.getCreateOrgCode()));
            //赋值
            if (areaNameMap!=null){
                List<KmsAcceptanceFormRespVo> vos = areaNameMap.get(o.getStoreRelatedId());
                if (CollectionUtil.listNotEmptyNotSizeZero(vos)){
                    o.setAreaName(vos.get(0).getAreaName());
                }
            }
        });
    }
}
