package com.biz.crm.acceptanceform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceStatusRecordMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceStatusRecordEntity;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceStatusRecordReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceStatusRecordRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 验收单状态流转表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsAcceptanceStatusRecordServiceExpandImpl")
public class KmsAcceptanceStatusRecordServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsAcceptanceStatusRecordMapper, KmsAcceptanceStatusRecordEntity> implements IKmsAcceptanceStatusRecordService {

    @Resource
    private KmsAcceptanceStatusRecordMapper kmsAcceptanceStatusRecordMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAcceptanceStatusRecordRespVo> findList(KmsAcceptanceStatusRecordReqVo reqVo){
        Page<KmsAcceptanceStatusRecordRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAcceptanceStatusRecordRespVo> list = kmsAcceptanceStatusRecordMapper.findList(page, reqVo);
        return PageResult.<KmsAcceptanceStatusRecordRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsAcceptanceStatusRecordRespVo
     */
    @Override
    public KmsAcceptanceStatusRecordRespVo query(KmsAcceptanceStatusRecordReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAcceptanceStatusRecordReqVo reqVo){
        KmsAcceptanceStatusRecordEntity entity = CrmBeanUtil.copy(reqVo,KmsAcceptanceStatusRecordEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAcceptanceStatusRecordReqVo reqVo){
        KmsAcceptanceStatusRecordEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAcceptanceStatusRecordReqVo reqVo){
        List<KmsAcceptanceStatusRecordEntity> kmsAcceptanceStatusRecordEntities = kmsAcceptanceStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceStatusRecordEntities)){
            kmsAcceptanceStatusRecordEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceStatusRecordEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAcceptanceStatusRecordReqVo reqVo){
        //设置状态为启用
        List<KmsAcceptanceStatusRecordEntity> kmsAcceptanceStatusRecordEntities = kmsAcceptanceStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceStatusRecordEntities)){
            kmsAcceptanceStatusRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceStatusRecordEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAcceptanceStatusRecordReqVo reqVo){
        //设置状态为禁用
        List<KmsAcceptanceStatusRecordEntity> kmsAcceptanceStatusRecordEntities = kmsAcceptanceStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceStatusRecordEntities)){
                kmsAcceptanceStatusRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceStatusRecordEntities);
    }

    /**
     * 保存验收单状态记录表
     * @param acceptanceFormEntities
     */
    @Override
    public void insert(List<KmsAcceptanceFormEntity> acceptanceFormEntities) {
        List<KmsAcceptanceStatusRecordEntity> recordEntities = CrmBeanUtil.copyList(acceptanceFormEntities,KmsAcceptanceStatusRecordEntity.class);
        recordEntities.forEach(o -> {
            setNull(o);
        });
        this.saveBatch(recordEntities);
    }

    private void setNull(KmsAcceptanceStatusRecordEntity o) {
        o.setId(null);
        o.setCreateDate(null);
        o.setCreateDateAll(null);
        o.setCreateDateSecond(null);
        o.setUpdateDateAll(null);
        o.setUpdateDateSecond(null);
        o.setUpdateDate(null);
    }

    /**
     * 保存验收单状态记录表
     * @param acceptanceFormEntities
     */
    @Override
    public void insert(KmsAcceptanceFormEntity acceptanceFormEntities) {
        KmsAcceptanceStatusRecordEntity recordEntity = CrmBeanUtil.copy(acceptanceFormEntities,KmsAcceptanceStatusRecordEntity.class);
        setNull(recordEntity);
        this.save(recordEntity);
    }
}
