package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsInterfaceParamOptionMapper;
import com.biz.crm.confadmin.model.KmsInterfaceParamOptionEntity;
import com.biz.crm.confadmin.service.IKmsInterfaceParamOptionService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamOptionReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceParamOptionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * kms抓单接口下拉参数接口实现
 *
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsInterfaceParamOptionServiceExpandImpl")
public class KmsInterfaceParamOptionServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsInterfaceParamOptionMapper, KmsInterfaceParamOptionEntity> implements IKmsInterfaceParamOptionService {

    @Resource
    private KmsInterfaceParamOptionMapper kmsInterfaceParamOptionMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsInterfaceParamOptionRespVo> findList(KmsInterfaceParamOptionReqVo reqVo){
        Page<KmsInterfaceParamOptionRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsInterfaceParamOptionRespVo> list = kmsInterfaceParamOptionMapper.findList(page, reqVo);
        return PageResult.<KmsInterfaceParamOptionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsInterfaceParamOptionRespVo
     */
    @Override
    public KmsInterfaceParamOptionRespVo query(KmsInterfaceParamOptionReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsInterfaceParamOptionReqVo reqVo){
        KmsInterfaceParamOptionEntity entity = CrmBeanUtil.copy(reqVo,KmsInterfaceParamOptionEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsInterfaceParamOptionReqVo reqVo){
        KmsInterfaceParamOptionEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsInterfaceParamOptionReqVo reqVo){
        List<KmsInterfaceParamOptionEntity> kmsInterfaceParamOptionEntities = kmsInterfaceParamOptionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsInterfaceParamOptionEntities)){
            kmsInterfaceParamOptionEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceParamOptionEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsInterfaceParamOptionReqVo reqVo){
        //设置状态为启用
        List<KmsInterfaceParamOptionEntity> kmsInterfaceParamOptionEntities = kmsInterfaceParamOptionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsInterfaceParamOptionEntities)){
            kmsInterfaceParamOptionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceParamOptionEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsInterfaceParamOptionReqVo reqVo){
        //设置状态为禁用
        List<KmsInterfaceParamOptionEntity> kmsInterfaceParamOptionEntities = kmsInterfaceParamOptionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsInterfaceParamOptionEntities)){
                kmsInterfaceParamOptionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceParamOptionEntities);
    }
}
