package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.helper.KmsInterfaceParamHelper;
import com.biz.crm.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.confadmin.mapper.KmsInterfaceParamMapper;
import com.biz.crm.confadmin.model.KmsInterfaceParamEntity;
import com.biz.crm.confadmin.model.KmsInterfaceParamOptionEntity;
import com.biz.crm.confadmin.model.KmsInterfaceSubParamOptionEntity;
import com.biz.crm.confadmin.service.IKmsInterfaceParamOptionService;
import com.biz.crm.confadmin.service.IKmsInterfaceParamService;
import com.biz.crm.confadmin.service.IKmsInterfaceSubParamOptionService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceParamOptionRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceSubParamOptionRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * kms抓单接口参数接口实现
 *
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsInterfaceParamServiceExpandImpl")
public class KmsInterfaceParamServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<KmsInterfaceParamMapper, KmsInterfaceParamEntity> implements IKmsInterfaceParamService {

    @Resource
    private KmsInterfaceParamMapper kmsInterfaceParamMapper;

    @Resource
    private KmsInterfaceParamHelper kmsInterfaceParamHelper;

    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;

    @Resource
    private IKmsInterfaceParamOptionService kmsInterfaceParamOptionService;

    @Resource
    private IKmsInterfaceSubParamOptionService kmsInterfaceSubParamOptionService;

    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsInterfaceParamRespVo> findList(KmsInterfaceParamReqVo reqVo) {
        Page<KmsInterfaceParamRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsInterfaceParamRespVo> list = kmsInterfaceParamMapper.findList(page, reqVo);
        return PageResult.<KmsInterfaceParamRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return kmsInterfaceParamRespVo
     */
    @Override
    public KmsInterfaceParamRespVo query(KmsInterfaceParamReqVo reqVo) {
        String paramEntityId = reqVo.getId();
        AssertUtils.isNotEmpty(paramEntityId, "数据主键不能为空");
        KmsInterfaceParamEntity kmsInterfaceParamEntity = kmsInterfaceParamMapper.selectById(paramEntityId);
        AssertUtils.isNotNull(kmsInterfaceParamEntity, "未查询的数据信息");
        KmsInterfaceParamRespVo respVo = CrmBeanUtil.copy(kmsInterfaceParamEntity, KmsInterfaceParamRespVo.class);
        //查询属性
        List<KmsInterfaceParamOptionEntity> optionEntities = kmsInterfaceParamOptionService.lambdaQuery()
                .eq(KmsInterfaceParamOptionEntity::getFieldId, paramEntityId)
                .list();
        respVo.setOptions(CrmBeanUtil.copyList(optionEntities, KmsInterfaceParamOptionRespVo.class));
        //查询子参数
        List<KmsInterfaceSubParamOptionEntity> subOptionEntities = kmsInterfaceSubParamOptionService.lambdaQuery()
                .eq(KmsInterfaceSubParamOptionEntity::getFieldId, paramEntityId)
                .list();
        respVo.setSubOptions(CrmBeanUtil.copyList(subOptionEntities, KmsInterfaceSubParamOptionRespVo.class));
        return respVo;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsInterfaceParamReqVo reqVo) {
        //数据校验
        kmsInterfaceParamHelper.paramCheck(reqVo);
        KmsInterfaceParamEntity entity = CrmBeanUtil.copy(reqVo, KmsInterfaceParamEntity.class);
        this.save(entity);
        //新增参数ID
        String paramId = entity.getId();
        reqVo.setId(paramId);
        KmsInterfaceParamRespVo newData = CrmBeanUtil.copy(entity, KmsInterfaceParamRespVo.class);
        //属性
        if (!org.springframework.util.CollectionUtils.isEmpty(reqVo.getOptions())) {
            List<KmsInterfaceParamOptionEntity> optionEntities = kmsInterfaceParamHelper.buildOptionEntity(reqVo);
            kmsInterfaceParamOptionService.saveBatch(optionEntities);
            newData.setOptions(CrmBeanUtil.copyList(optionEntities, KmsInterfaceParamOptionRespVo.class));
        }
        //子参数
        if (!org.springframework.util.CollectionUtils.isEmpty(reqVo.getSubOptions())) {
            List<KmsInterfaceSubParamOptionEntity> subOptionEntities = kmsInterfaceParamHelper.buildSubOptionEntity(reqVo);
            kmsInterfaceSubParamOptionService.saveBatch(subOptionEntities);
            newData.setSubOptions(CrmBeanUtil.copyList(subOptionEntities, KmsInterfaceSubParamOptionRespVo.class));
        }
        Object menuCode = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), newData);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsInterfaceParamReqVo reqVo) {
        //数据校验
        kmsInterfaceParamHelper.paramCheck(reqVo);
        AssertUtils.isNotEmpty(reqVo.getId(), "数据主键不能为空");
        KmsInterfaceParamEntity kmsInterfaceParamEntity = kmsInterfaceParamMapper.selectById(reqVo.getId());
        AssertUtils.isNotNull(kmsInterfaceParamEntity, "未查询的数据信息");
        //控件类型不能修改
        if (!reqVo.getFieldClassify().equals(kmsInterfaceParamEntity.getFieldClassify())) {
            throw new BusinessException("控件类型不能修改");
        }
        KmsInterfaceParamRespVo oldData = this.query(reqVo);
        BeanUtils.copyProperties(reqVo, kmsInterfaceParamEntity);
        this.updateById(kmsInterfaceParamEntity);
        String paramEntityId = kmsInterfaceParamEntity.getId();
        //属性
        if (!org.springframework.util.CollectionUtils.isEmpty(reqVo.getOptions())) {
            //删除属性信息
            kmsInterfaceParamOptionService.lambdaUpdate().eq(KmsInterfaceParamOptionEntity::getFieldId, paramEntityId).remove();
            List<KmsInterfaceParamOptionEntity> optionEntities = kmsInterfaceParamHelper.buildOptionEntity(reqVo);
            kmsInterfaceParamOptionService.saveBatch(optionEntities);
        }
        //子参数
        if (!org.springframework.util.CollectionUtils.isEmpty(reqVo.getSubOptions())) {
            //删除子参数信息
            kmsInterfaceSubParamOptionService.lambdaUpdate().eq(KmsInterfaceSubParamOptionEntity::getFieldId, paramEntityId).remove();
            List<KmsInterfaceSubParamOptionEntity> subOptionEntities = kmsInterfaceParamHelper.buildSubOptionEntity(reqVo);
            kmsInterfaceSubParamOptionService.saveBatch(subOptionEntities);
        }
        KmsInterfaceParamRespVo newData = this.query(reqVo);
        Object menuCode = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), oldData, newData);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsInterfaceParamReqVo reqVo) {
        List<KmsInterfaceParamEntity> kmsInterfaceParamEntities = kmsInterfaceParamMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsInterfaceParamEntities)) {
            kmsInterfaceParamEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceParamEntities);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsInterfaceParamReqVo reqVo) {
        //设置状态为启用
        List<KmsInterfaceParamEntity> kmsInterfaceParamEntities = kmsInterfaceParamMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsInterfaceParamEntities)) {
            kmsInterfaceParamEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceParamEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsInterfaceParamReqVo reqVo) {
        //设置状态为禁用
        List<KmsInterfaceParamEntity> kmsInterfaceParamEntities = kmsInterfaceParamMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsInterfaceParamEntities)) {
            kmsInterfaceParamEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceParamEntities);
    }
}
