package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsInterfaceSubParamOptionMapper;
import com.biz.crm.confadmin.model.KmsInterfaceSubParamOptionEntity;
import com.biz.crm.confadmin.service.IKmsInterfaceSubParamOptionService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceSubParamOptionReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceSubParamOptionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * kms抓单接口参数子参数接口实现
 *
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsInterfaceSubParamOptionServiceExpandImpl")
public class KmsInterfaceSubParamOptionServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsInterfaceSubParamOptionMapper, KmsInterfaceSubParamOptionEntity> implements IKmsInterfaceSubParamOptionService {

    @Resource
    private KmsInterfaceSubParamOptionMapper kmsInterfaceSubParamOptionMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsInterfaceSubParamOptionRespVo> findList(KmsInterfaceSubParamOptionReqVo reqVo){
        Page<KmsInterfaceSubParamOptionRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsInterfaceSubParamOptionRespVo> list = kmsInterfaceSubParamOptionMapper.findList(page, reqVo);
        return PageResult.<KmsInterfaceSubParamOptionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsInterfaceSubParamOptionRespVo
     */
    @Override
    public KmsInterfaceSubParamOptionRespVo query(KmsInterfaceSubParamOptionReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsInterfaceSubParamOptionReqVo reqVo){
        KmsInterfaceSubParamOptionEntity entity = CrmBeanUtil.copy(reqVo,KmsInterfaceSubParamOptionEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsInterfaceSubParamOptionReqVo reqVo){
        KmsInterfaceSubParamOptionEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsInterfaceSubParamOptionReqVo reqVo){
        List<KmsInterfaceSubParamOptionEntity> kmsInterfaceSubParamOptionEntities = kmsInterfaceSubParamOptionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsInterfaceSubParamOptionEntities)){
            kmsInterfaceSubParamOptionEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceSubParamOptionEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsInterfaceSubParamOptionReqVo reqVo){
        //设置状态为启用
        List<KmsInterfaceSubParamOptionEntity> kmsInterfaceSubParamOptionEntities = kmsInterfaceSubParamOptionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsInterfaceSubParamOptionEntities)){
            kmsInterfaceSubParamOptionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceSubParamOptionEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsInterfaceSubParamOptionReqVo reqVo){
        //设置状态为禁用
        List<KmsInterfaceSubParamOptionEntity> kmsInterfaceSubParamOptionEntities = kmsInterfaceSubParamOptionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsInterfaceSubParamOptionEntities)){
                kmsInterfaceSubParamOptionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsInterfaceSubParamOptionEntities);
    }
}
