package com.biz.crm.finance.helper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.funcation.KmsAuditFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormExportRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.helper
 * @ClassName KmsAuditFormHelper
 * @Author Gavin
 * @Date 2021/6/11 上午11:06
 * @Description 稽核助手
 */
@Slf4j
@Component
public class KmsAuditFormHelper {

    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;

    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;

    private static final BigDecimal BASE_1000 = new BigDecimal(1000);

    @Resource
    private KmsAuditFunction kmsAuditFunction;

    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;

    /**
     * SAP数据根据稽核条件汇总
     *
     * @param e
     * @param a
     */
    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {
        String templateId = a.getId();
        //判断是否满足商超条件
        Map<String, KmsAuditTemplateDirectRespVo> directRespVoMap = a.getDirectVos().stream()
                .collect(Collectors.toMap(KmsAuditTemplateDirectRespVo::getBsDirectSystemId, Function.identity()));
        KmsAuditTemplateDirectRespVo templateDirectRespVo = directRespVoMap.get(a.getBsDirectSystemId());
        //判断是否已汇总
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(a));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.summary(invoice, a, templateDirectRespVo, auditFormEntities, relationEntities);
    }

    /**
     * 匹配数据信息
     *
     * @param respVo
     * @param templateRespVo
     */
    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.matchData(respVo, templateRespVo);
    }

    /**
     * 查询已匹配验收单
     *
     * @param respVo
     * @param templateRespVo
     */
    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //获取稽核条件
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.matchDataSucc(respVo, templateRespVo);
    }


    /**
     * 数据绑定
     *
     * @param afVo
     * @param templateRespVo
     */
    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        //获取稽核条件
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.matchDataBinding(afVo, templateRespVo);
    }

    /**
     * 手动匹配/取消根据Ids查询验收数据
     *
     * @param acceptanceFormIds
     * @param afVo
     * @param templateRespVo
     */
    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //获取稽核条件
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.findMatchDataByIds(relationIdIds, respVo, templateRespVo);
    }

    /**
     * 取消数据绑定
     *
     * @param afVo
     * @param templateRespVo
     */
    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        //获取稽核条件
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.cancelMatchData(relationIdIds, afVo, templateRespVo);
    }

    /**
     * 未匹配验收单查询
     *
     * @param page
     * @param reqVo
     * @return
     */
    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        //查询模版信息
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(reqVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        //商超ID
        List<String> directIds = templateRespVo.getDirectVos().stream()
                .map(KmsAuditTemplateDirectRespVo::getDirectId).collect(Collectors.toList());
        reqVo.setDirectIds(directIds);
        //获取匹配条件标示
        KmsAuditConditionEnum conditionEnum = KmsUtils.getConditionEnum(templateRespVo);
        //获取稽核条件
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return Lists.newArrayList();
        }
        return baseAuditFunction.notmatchedAcceptanceFormList(page, reqVo);
    }

    /**
     * 手动匹配查询待匹配验收单数据列表
     *
     * @param respVo
     * @param templateRespVo
     * @return
     */
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return new PageResult<>();
        }
        return baseAuditFunction.waitMatchedAcc(reqVo, respVo, templateRespVo);
    }

    /**
     * 查询已匹配验收单数据列表
     *
     * @param respVo
     * @param templateRespVo
     * @return
     */
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return new PageResult<>();
        }
        return baseAuditFunction.matchedAcc(reqVo, respVo, templateRespVo);
    }

    /**
     * 稽核匹配导出数据封装
     *
     * @param list
     * @return
     */
    public List<KmsAuditFormExportRespVo> buildAuditExport(List<KmsAuditFormRespVo> list) {
        List<KmsAuditFormExportRespVo> exportRespVos = Lists.newArrayList();
        list.forEach(o -> {
            o.setAuditResult(KmsEnum.AuditResult.GETMAP.get(o.getAuditResult()));
            o.setAuditStatus(KmsEnum.AuditStatus.GETMAP.get(o.getAuditStatus()));
            List<KmsAuditFormExportRespVo> respVos = Lists.newArrayList();
            List<KmsSapOrderFormRespVo> sapOrderFormVos = o.getSapOrderFormVos();
            List<KmsAuditAcceptanceFormRespVo> acceptanceFormVos = o.getAcceptanceFormVos();
            int aSize = sapOrderFormVos.size();
            int bSize = acceptanceFormVos.size();
            int size = aSize >= bSize ? aSize : bSize;
            for (int i = 0; i < size; i++) {
                KmsAuditFormExportRespVo vo = new KmsAuditFormExportRespVo();
                if (respVos.size() == 0) {
                    vo = CrmBeanUtil.copy(o, KmsAuditFormExportRespVo.class);
                    vo.setSapPostingDateExport(DateUtil.format(DateUtil.getDateByFormat(
                            vo.getSapPostingDate(), DateUtil.DEFAULT_MONTH_DAY_PATTERN),
                            DateUtil.DEFAULT_DAY_PATTERN));
                }
                if (sapOrderFormVos.size() - 1 >= i) {
                    KmsSapOrderFormRespVo sapVo = sapOrderFormVos.get(i);
                    vo.setName4(sapVo.getName4());
                    vo.setPernr(sapVo.getPernr());
                    vo.setDistributor(sapVo.getDistributor());
                    vo.setSapNo(sapVo.getSapNo());
                    vo.setVgbel(sapVo.getVgbel());
                    vo.setItemSapAmount(sapVo.getSapAmount().toString());
                    vo.setItemSapAmountNot(sapVo.getSapAmountNot().toString());
                    vo.setItemSapDistributor(sapVo.getDistributor());
                    vo.setItemSapKunag(sapVo.getKunag());
                    vo.setItemSapKunagname(sapVo.getKunagname());
                    vo.setItemSapKunnr(sapVo.getKunnr());
                    vo.setItemSapKunnrname(sapVo.getKunnrname());
                    vo.setItemSapMaterielCode(sapVo.getSapMaterielCode());
                    vo.setItemSapMaterielName(sapVo.getSapMaterielName());
                    vo.setItemSapPostingDate(DateUtil.format(DateUtil.getDateByFormat(
                            sapVo.getSapPostingDate(), DateUtil.DEFAULT_MONTH_DAY_PATTERN),
                            DateUtil.DEFAULT_DAY_PATTERN));
                    vo.setItemSapProductType(sapVo.getProductType());
                    vo.setItemSapQuantity(sapVo.getSapQuantity().toString());
                    vo.setItemSapStoreCode(sapVo.getStoreCode());
                    vo.setItemSapStoreName(sapVo.getStoreName());
                    vo.setNetwr(sapVo.getNetwr().toString());
                    vo.setMwsbp(sapVo.getMwsi1().toString());
                    vo.setKzwi1(sapVo.getKzwi1().toString());
                    vo.setKzwi4(sapVo.getKzwi4().toString());
                    vo.setMwsi1(sapVo.getMwsi1().toString());
                    vo.setYk04(sapVo.getYk04().toString());
                    vo.setYk11(sapVo.getYk11().toString());
                    vo.setYk99(sapVo.getYk99().toString());
                    vo.setZst2(sapVo.getZst2().toString());
                    vo.setErzet(DateUtil.format(DateUtil.getDateByFormat(
                            sapVo.getErzet(), DateUtil.DEFAULT_DATE_TIME_PATTERN),
                            DateUtil.DEFAULT_DAY_PATTERN));
                    vo.setAubel(sapVo.getAubel());
                    vo.setVbakerdat(DateUtil.format(DateUtil.getDateByFormat(
                            sapVo.getVbakerdat(), DateUtil.DEFAULT_MONTH_DAY_PATTERN),
                            DateUtil.DEFAULT_DAY_PATTERN));
                }
                if (acceptanceFormVos.size() - 1 >= i) {
                    KmsAuditAcceptanceFormRespVo accVo = acceptanceFormVos.get(i);
                    vo.setItemAccAcceptanceAmount(accVo.getAcceptanceAmount());
                    vo.setItemAccAcceptanceAmountNot(accVo.getAcceptanceAmountNot());
                    vo.setItemAccAcceptanceDate(accVo.getAcceptanceDate());
                    vo.setItemAccAcceptanceQuantity(accVo.getAcceptanceQuantity());
                    vo.setItemAccAcceptanceType(accVo.getAcceptanceType());
                    vo.setItemAccAreaCode(accVo.getAreaCode());
                    vo.setItemAccAreaName(accVo.getAreaName());
                    vo.setItemAccBusinessArea(accVo.getBusinessArea());
                    vo.setItemAccGoodsCode(accVo.getGoodsCode());
                    vo.setItemAccGoodsName(accVo.getGoodsName());
                    vo.setItemAccKaCode(accVo.getKaCode());
                    vo.setItemAccKaName(accVo.getKaName());
                    vo.setItemAccKaOrderNumber(accVo.getKaOrderNumber());
                    vo.setItemAccOrderNumber(accVo.getOrderNumber());
                    vo.setItemAccSoldToPartyCode(accVo.getSoldToPartyCode());
                    vo.setItemAccSoldToPartyName(accVo.getSoldToPartyName());
                    vo.setItemAccStoreCode(accVo.getStoreCode());
                    vo.setItemAccStoreName(accVo.getStoreName());
                    vo.setItemAccKaGoodsCode(accVo.getKaGoodsCode());
                    vo.setItemAccKaGoodsName(accVo.getKaGoodsName());
                    vo.setItemAccKaStoreCode(accVo.getKaStoreCode());
                    vo.setItemAccKaStoreName(accVo.getKaStoreName());
                }
                respVos.add(vo);
            }
            exportRespVos.addAll(respVos);
        });

        return exportRespVos;
    }

    /**
     * 处理延迟收货查询验收单数据信息
     *
     * @param o
     * @param auditTemplateRespVo
     */
    public void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {
        BaseAuditFunction baseAuditFunction = kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(auditTemplateRespVo));
        if (ObjectUtils.isEmpty(baseAuditFunction)) {
            return;
        }
        baseAuditFunction.delayedReceiptAcc(o, auditTemplateRespVo);
    }

    /**
     * 根据稽核ID集合批量查询已匹配验收单集合
     *
     * @param reqVo
     * @param templateRespVo
     * @return
     */
    public List<KmsAuditAcceptanceFormRespVo> matchDataSuccList(KmsAuditFormReqVo reqVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo params = new KmsAcceptanceFormReqVo();
        //查询已匹配验收单数据信息
        params.setAuditTemplateId(templateRespVo.getId());
        params.setAuditIds(reqVo.getIds());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = kmsAcceptanceFormMapper
                .findMatchedSuccPDS(params);
        acceptanceFormSuccRespVos.forEach(a -> {
            a.setId(a.getGoodsId());
            //验收金额处理
            //KmsUtils.acceptanceAmountHandle(a,taxRate);
        });
        return acceptanceFormSuccRespVos;
    }
}