package com.biz.crm.finance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.finance.model.KmsAuditTemplateDirectEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateDirectReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽核模板商超信息
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
public interface KmsAuditTemplateDirectMapper extends BaseMapper<KmsAuditTemplateDirectEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsAuditTemplateDirectReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAuditTemplateDirectRespVo> findList(Page<KmsAuditTemplateDirectRespVo> page, @Param("vo") KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo);

    /**
     * 查询模版关联商超
     *
     * @param directReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAuditTemplateDirectRespVo> findList(@Param("vo") KmsAuditTemplateDirectReqVo directReqVo);

    /**
     * 稽核模版查询直营体系
     *
     * @param auditTemplateId
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectCustomerOrgRespVo> findSystemDirectList(@Param("auditTemplateId") String auditTemplateId);
}
