package com.biz.crm.finance.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormExportRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;

import java.util.List;

/**
 * 稽核数据接口
 *
 * @author Gavin
 * @date 2021-05-27 11:09:31
 */
public interface IKmsAuditFormService extends IService<KmsAuditFormEntity> {

    /**
     * 列表
     *
     * @param kmsAuditFormReqVo
     * @return PageResult<KmsAuditFormRespVo>
     */
    PageResult<KmsAuditFormRespVo> findList(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 查询
     *
     * @param kmsAuditFormReqVo
     * @return KmsAuditFormRespVo
     */
    KmsAuditFormRespVo query(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 新增
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    void save(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 更新
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    void update(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 删除
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    void deleteBatch(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 启用
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    void enableBatch(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 禁用
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    void disableBatch(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 确认
     *
     * @param ids
     */
    void confirm(List<String> ids);

    /**
     * 未匹配验收单列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    PageResult<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 添加备注
     *
     * @param kmsAuditFormReqVo
     */
    void addRemark(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 手动取消匹配提交
     *
     * @param kmsAuditFormReqVo
     */
    void manualCancelmatch(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 手动匹配提交
     *
     * @param kmsAuditFormReqVo
     */
    void manualmatch(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 手动匹配详情
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    KmsAuditFormRespVo manualmatchQuery(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 拉取SAP数据
     *
     * @param kmsSapOrderFormReqVo
     */
    void pullSap(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 查询模版下待匹配稽核数据信息
     *
     * @param formReqVo
     * @return
     */
    List<KmsAuditFormRespVo> findWaitList(KmsAuditFormReqVo formReqVo);

    /**
     * 稽核自动匹配
     *
     * @param afVo
     * @param templateRespVo
     */
    void auditMatch(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo);

    /**
     * 手动匹配查询待匹配验收单数据列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 查询已匹配验收单数据列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 取消确认
     *
     * @param ids
     */
    void cancelConfirm(List<String> ids);

    /**
     * 刷新稽核结果
     *
     * @param formReqVo
     */
    void refreshAuditResult(KmsAuditFormReqVo formReqVo);

    /**
     * 稽核匹配导出
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    PageResult<KmsAuditFormExportRespVo> auditExport(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 汇总
     */
    void pullSapSummary(KmsSapOrderFormReqVo reqVo);

    /**
     * 根据ID查询稽核数据
     *
     * @param ids
     * @return
     */
    List<KmsAuditFormRespVo> findListByIds(List<String> ids);

    /**
     * 稽核匹配汇总
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    PageResult<KmsAuditFormRespVo> matchSummaryReport(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 稽核匹配汇总
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    KmsAuditFormRespVo matchSummaryTotalCount(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 处理延迟收货
     *
     * @param o
     * @param auditTemplateRespVo
     */
    void delayedReceipt(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo);

    /**
     * 未匹配验收单查询稽核匹配列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    PageResult<KmsAuditFormRespVo> selectMatchList(KmsAuditFormReqVo kmsAuditFormReqVo);

    /**
     * 未匹配验收单匹配稽核单提交
     *
     * @param kmsAuditFormReqVo
     */
    void submitUnmatchedAcce(KmsAuditFormReqVo kmsAuditFormReqVo);
}

