package com.biz.crm.grabrule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.grabrule.model.KmsGrabRuleStoreEntity;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleStoreReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleStoreRespVo;

import java.util.List;

/**
 * 抓单规则门店配置表接口
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
public interface IKmsGrabRuleStoreService extends IService<KmsGrabRuleStoreEntity> {

    /**
     * 列表
     * @param kmsGrabRuleStoreReqVo
     * @return PageResult<KmsGrabRuleStoreRespVo>
     */
    PageResult<KmsGrabRuleStoreRespVo> findList(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 查询
     * @param kmsGrabRuleStoreReqVo
     * @return KmsGrabRuleStoreRespVo
     */
    KmsGrabRuleStoreRespVo query(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 新增
     * @param kmsGrabRuleStoreReqVo
     * @return
     */
    void save(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 更新
     * @param kmsGrabRuleStoreReqVo
     * @return
     */
    void update(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 删除
     * @param kmsGrabRuleStoreReqVo
     * @return
     */
    void deleteBatch(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 启用
     * @param kmsGrabRuleStoreReqVo
     * @return
     */
    void enableBatch(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 禁用
     * @param kmsGrabRuleStoreReqVo
     * @return
     */
    void disableBatch(KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 规则ID查询门店列表
     * @param ruleId
     * @return
     */
    List<KmsGrabRuleStoreRespVo> findByGrabRuleId(String ruleId);
}

