package com.biz.crm.grabrule.service;

import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.grabrule.resp.KmsLoggerDataProcessRespVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsLoggerDataProcessReqVo;

import java.util.Map;

/**
 * 单据抓取日志接口
 *
 * @author Gavin
 * @date 2021-05-11 11:32:23
 */
public interface IKmsLoggerDataProcessService extends IService<KmsLoggerDataProcessEntity> {

    /**
     * 列表
     * @param kmsLoggerDataProcessReqVo
     * @return PageResult<KmsLoggerDataProcessRespVo>
     */
    PageResult<KmsLoggerDataProcessRespVo> findList(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

    /**
     * 查询
     * @param kmsLoggerDataProcessReqVo
     * @return KmsLoggerDataProcessRespVo
     */
    KmsLoggerDataProcessRespVo query(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

    /**
     * 新增
     * @param kmsLoggerDataProcessReqVo
     * @return
     */
    void save(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

    /**
     * 更新
     * @param kmsLoggerDataProcessReqVo
     * @return
     */
    void update(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

    /**
     * 删除
     * @param kmsLoggerDataProcessReqVo
     * @return
     */
    void deleteBatch(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

    /**
     * 启用
     * @param kmsLoggerDataProcessReqVo
     * @return
     */
    void enableBatch(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

    /**
     * 禁用
     * @param kmsLoggerDataProcessReqVo
     * @return
     */
    void disableBatch(KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);
}

