package com.biz.crm.orderform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.orderform.service.IKmsOrderGoodsService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商超订货单商品表
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Slf4j
@RestController
@RequestMapping("/kmsordergoods")
@Api(tags = "订货单商品信息")
public class KmsOrderGoodsController {
    @Autowired
    private IKmsOrderGoodsService kmsOrderGoodsService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsOrderGoodsRespVo>> list(@RequestBody KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        PageResult<KmsOrderGoodsRespVo> result=kmsOrderGoodsService.findList(kmsOrderGoodsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsOrderGoodsRespVo> query(@RequestBody KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        KmsOrderGoodsRespVo respVo=kmsOrderGoodsService.query(kmsOrderGoodsReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        kmsOrderGoodsService.save(kmsOrderGoodsReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        kmsOrderGoodsService.update(kmsOrderGoodsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        kmsOrderGoodsService.deleteBatch(kmsOrderGoodsReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        kmsOrderGoodsService.enableBatch(kmsOrderGoodsReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsOrderGoodsReqVo kmsOrderGoodsReqVo) {
        kmsOrderGoodsService.disableBatch(kmsOrderGoodsReqVo);
        return Result.ok("禁用成功");
    }
}
