package com.biz.crm.rawdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.req.KmsAcceptanceFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.rawdata.service.IKmsAcceptanceFormDetailDwService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 验收单原始数据表
 *
 * @author Gavin
 * @date 2021-05-12 19:21:09
 */
@Slf4j
@RestController
@RequestMapping("/kmsacceptanceformdetaildw")
//@Api(tags = "验收单原始数据表")
public class KmsAcceptanceFormDetailDwController {
    @Autowired
    private IKmsAcceptanceFormDetailDwService kmsAcceptanceFormDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsAcceptanceFormDetailDwRespVo>> list(@RequestBody KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        PageResult<KmsAcceptanceFormDetailDwRespVo> result=kmsAcceptanceFormDetailDwService.findList(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsAcceptanceFormDetailDwRespVo> query(@RequestBody KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        KmsAcceptanceFormDetailDwRespVo respVo=kmsAcceptanceFormDetailDwService.query(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        kmsAcceptanceFormDetailDwService.save(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        kmsAcceptanceFormDetailDwService.update(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        kmsAcceptanceFormDetailDwService.deleteBatch(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        kmsAcceptanceFormDetailDwService.enableBatch(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsAcceptanceFormDetailDwReqVo kmsAcceptanceFormDetailDwReqVo) {
        kmsAcceptanceFormDetailDwService.disableBatch(kmsAcceptanceFormDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
