package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsAcceptanceGoodsDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceGoodsDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsAcceptanceGoodsDetailDwMapper;
import com.biz.crm.rawdata.model.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsAcceptanceGoodsDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 验收单原始单据详情接口实现
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsAcceptanceGoodsDetailDwServiceExpandImpl")
public class KmsAcceptanceGoodsDetailDwServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsAcceptanceGoodsDetailDwMapper, KmsAcceptanceGoodsDetailDwEntity> implements IKmsAcceptanceGoodsDetailDwService {

    @Resource
    private KmsAcceptanceGoodsDetailDwMapper kmsAcceptanceGoodsDetailDwMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAcceptanceGoodsDetailDwRespVo> findList(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        Page<KmsAcceptanceGoodsDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAcceptanceGoodsDetailDwRespVo> list = kmsAcceptanceGoodsDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsAcceptanceGoodsDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsAcceptanceGoodsDetailDwRespVo
     */
    @Override
    public KmsAcceptanceGoodsDetailDwRespVo query(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        KmsAcceptanceGoodsDetailDwEntity entity = CrmBeanUtil.copy(reqVo,KmsAcceptanceGoodsDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        KmsAcceptanceGoodsDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        List<KmsAcceptanceGoodsDetailDwEntity> kmsAcceptanceGoodsDetailDwEntities = kmsAcceptanceGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceGoodsDetailDwEntities)){
            kmsAcceptanceGoodsDetailDwEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceGoodsDetailDwEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        //设置状态为启用
        List<KmsAcceptanceGoodsDetailDwEntity> kmsAcceptanceGoodsDetailDwEntities = kmsAcceptanceGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceGoodsDetailDwEntities)){
            kmsAcceptanceGoodsDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceGoodsDetailDwEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAcceptanceGoodsDetailDwReqVo reqVo){
        //设置状态为禁用
        List<KmsAcceptanceGoodsDetailDwEntity> kmsAcceptanceGoodsDetailDwEntities = kmsAcceptanceGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceGoodsDetailDwEntities)){
                kmsAcceptanceGoodsDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceGoodsDetailDwEntities);
    }
}
