package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsInventoryDataFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsInventoryDataFormDetailDwMapper;
import com.biz.crm.rawdata.model.KmsInventoryDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsInventoryDataFormDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 库存商超原始单据接口实现
 *
 * @author gavin
 * @date 2021-11-24 14:07:31
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsInventoryDataFormDetailDwServiceExpandImpl")
public class KmsInventoryDataFormDetailDwServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<KmsInventoryDataFormDetailDwMapper, KmsInventoryDataFormDetailDwEntity> implements IKmsInventoryDataFormDetailDwService {

    @Resource
    private KmsInventoryDataFormDetailDwMapper kmsInventoryDataFormDetailDwMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsInventoryDataFormDetailDwRespVo> findList(KmsInventoryDataFormDetailDwReqVo reqVo) {
        Page<KmsInventoryDataFormDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsInventoryDataFormDetailDwRespVo> list = kmsInventoryDataFormDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsInventoryDataFormDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return kmsInventoryDataFormDetailDwRespVo
     */
    @Override
    public KmsInventoryDataFormDetailDwRespVo query(KmsInventoryDataFormDetailDwReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsInventoryDataFormDetailDwReqVo reqVo) {
        KmsInventoryDataFormDetailDwEntity entity = CrmBeanUtil.copy(reqVo, KmsInventoryDataFormDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsInventoryDataFormDetailDwReqVo reqVo) {
        KmsInventoryDataFormDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsInventoryDataFormDetailDwReqVo reqVo) {
        List<KmsInventoryDataFormDetailDwEntity> kmsInventoryDataFormDetailDwEntities = kmsInventoryDataFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsInventoryDataFormDetailDwEntities)) {
            kmsInventoryDataFormDetailDwEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsInventoryDataFormDetailDwEntities);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsInventoryDataFormDetailDwReqVo reqVo) {
        //设置状态为启用
        List<KmsInventoryDataFormDetailDwEntity> kmsInventoryDataFormDetailDwEntities = kmsInventoryDataFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsInventoryDataFormDetailDwEntities)) {
            kmsInventoryDataFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsInventoryDataFormDetailDwEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsInventoryDataFormDetailDwReqVo reqVo) {
        //设置状态为禁用
        List<KmsInventoryDataFormDetailDwEntity> kmsInventoryDataFormDetailDwEntities = kmsInventoryDataFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsInventoryDataFormDetailDwEntities)) {
            kmsInventoryDataFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsInventoryDataFormDetailDwEntities);
    }

    /**
     * 查询待转换单据信息
     *
     * @param params
     * @return
     */
    @Override
    public List<KmsInventoryDataFormDetailDwRespVo> findNotTransData(KmsInventoryDataFormDetailDwReqVo params) {
        return kmsInventoryDataFormDetailDwMapper.findNotTransData(params);
    }
}
