package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsReturnGoodsDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnGoodsDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsReturnGoodsDetailDwMapper;
import com.biz.crm.rawdata.model.KmsReturnGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsReturnGoodsDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 原单订单行数据信息接口实现
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsReturnGoodsDetailDwServiceExpandImpl")
public class KmsReturnGoodsDetailDwServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsReturnGoodsDetailDwMapper, KmsReturnGoodsDetailDwEntity> implements IKmsReturnGoodsDetailDwService {

    @Resource
    private KmsReturnGoodsDetailDwMapper kmsReturnGoodsDetailDwMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsReturnGoodsDetailDwRespVo> findList(KmsReturnGoodsDetailDwReqVo reqVo){
        Page<KmsReturnGoodsDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsReturnGoodsDetailDwRespVo> list = kmsReturnGoodsDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsReturnGoodsDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsReturnGoodsDetailDwRespVo
     */
    @Override
    public KmsReturnGoodsDetailDwRespVo query(KmsReturnGoodsDetailDwReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsReturnGoodsDetailDwReqVo reqVo){
        KmsReturnGoodsDetailDwEntity entity = CrmBeanUtil.copy(reqVo,KmsReturnGoodsDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsReturnGoodsDetailDwReqVo reqVo){
        KmsReturnGoodsDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsReturnGoodsDetailDwReqVo reqVo){
        List<KmsReturnGoodsDetailDwEntity> kmsReturnGoodsDetailDwEntities = kmsReturnGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnGoodsDetailDwEntities)){
            kmsReturnGoodsDetailDwEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsReturnGoodsDetailDwEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsReturnGoodsDetailDwReqVo reqVo){
        //设置状态为启用
        List<KmsReturnGoodsDetailDwEntity> kmsReturnGoodsDetailDwEntities = kmsReturnGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnGoodsDetailDwEntities)){
            kmsReturnGoodsDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnGoodsDetailDwEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsReturnGoodsDetailDwReqVo reqVo){
        //设置状态为禁用
        List<KmsReturnGoodsDetailDwEntity> kmsReturnGoodsDetailDwEntities = kmsReturnGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnGoodsDetailDwEntities)){
                kmsReturnGoodsDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnGoodsDetailDwEntities);
    }
}
