package com.biz.crm.salesdata.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.salesdata.req.KmsSalesDataReqVo;
import com.biz.crm.nebular.kms.salesdata.resp.KmsSalesDataRespVo;
import com.biz.crm.salesdata.model.KmsSalesDataEntity;

import java.util.List;

/**
 * 销售数据表接口
 *
 * @author gavin
 * @date 2021-11-24 14:22:40
 */
public interface IKmsSalesDataService extends IService<KmsSalesDataEntity> {

    /**
     * 列表
     *
     * @param kmsSalesDataReqVo
     * @return PageResult<KmsSalesDataRespVo>
     */
    PageResult<KmsSalesDataRespVo> findList(KmsSalesDataReqVo kmsSalesDataReqVo);


    /**
     * 查询
     *
     * @param id
     * @return KmsSalesDataRespVo
     */
    KmsSalesDataRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsSalesDataReqVo
     * @return
     */
    void save(KmsSalesDataReqVo kmsSalesDataReqVo);

    /**
     * 更新
     *
     * @param kmsSalesDataReqVo
     * @return
     */
    void update(KmsSalesDataReqVo kmsSalesDataReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param kmsSalesDataReqVo
     * @return
     */
    void enableBatch(KmsSalesDataReqVo kmsSalesDataReqVo);

    /**
     * 禁用
     *
     * @param kmsSalesDataReqVo
     * @return
     */
    void disableBatch(KmsSalesDataReqVo kmsSalesDataReqVo);

    /**
     * 自动转换销售数据
     *
     * @param o
     */
    void autoTransData(KmsSaleDataFormDetailDwRespVo o);

    /**
     * 手动转换销售数据
     *
     * @param kmsSalesDataReqVo
     */
    void manualTrans(KmsSalesDataReqVo kmsSalesDataReqVo);

}

