package com.biz.crm.sap.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.sap.req.KmsSapInvoiceReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;

import java.util.List;

/**
 * SAP发票信息接口
 *
 * @author Gavin
 * @date 2021-06-01 17:23:11
 */
public interface IKmsSapInvoiceService extends IService<KmsSapInvoiceEntity> {

    /**
     * 根据稽核ID查询关联SAP数据
     * @param auditFormId
     * @return
     */
    List<KmsSapOrderFormRespVo> findByAuditId(String auditFormId);

    /**
     * SAP原始数据列表
     * @param KmsSapInvoiceReqVo
     * @return
     */
    PageResult<KmsSapInvoiceRespVo> findSapInvoicePage(KmsSapInvoiceReqVo params);
}

