package com.biz.crm.sap.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.finance.helper.KmsAuditTemplateHelper;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.helper.KmsSapHelper;
import com.biz.crm.sap.mapper.KmsSapOrderFormMapper;
import com.biz.crm.sap.model.KmsSapOrderFormEntity;
import com.biz.crm.sap.service.IKmsSapInvoiceService;
import com.biz.crm.sap.service.IKmsSapOrderFormService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * SAP数据接口实现
 *
 * @author Gavin
 * @date 2021-05-27 14:34:14
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsSapOrderFormServiceExpandImpl")
public class KmsSapOrderFormServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsSapOrderFormMapper, KmsSapOrderFormEntity> implements IKmsSapOrderFormService {

    @Resource
    private KmsSapOrderFormMapper kmsSapOrderFormMapper;

    @Resource
    private KmsSapHelper kmsSapHelper;

    @Resource
    private IKmsSapInvoiceService kmsSapInvoiceService;

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Resource
    private KmsAuditTemplateHelper kmsAuditTemplateHelper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsSapOrderFormRespVo> findList(KmsSapOrderFormReqVo reqVo){
        Page<KmsSapOrderFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsSapOrderFormRespVo> list = kmsSapOrderFormMapper.findList(page, reqVo);
        return PageResult.<KmsSapOrderFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsSapOrderFormRespVo
     */
    @Override
    public KmsSapOrderFormRespVo query(KmsSapOrderFormReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsSapOrderFormReqVo reqVo){
        KmsSapOrderFormEntity entity = CrmBeanUtil.copy(reqVo,KmsSapOrderFormEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsSapOrderFormReqVo reqVo){
        KmsSapOrderFormEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsSapOrderFormReqVo reqVo){
        List<KmsSapOrderFormEntity> kmsSapOrderFormEntities = kmsSapOrderFormMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsSapOrderFormEntities)){
            kmsSapOrderFormEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsSapOrderFormEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsSapOrderFormReqVo reqVo){
        //设置状态为启用
        List<KmsSapOrderFormEntity> kmsSapOrderFormEntities = kmsSapOrderFormMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsSapOrderFormEntities)){
            kmsSapOrderFormEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsSapOrderFormEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsSapOrderFormReqVo reqVo){
        //设置状态为禁用
        List<KmsSapOrderFormEntity> kmsSapOrderFormEntities = kmsSapOrderFormMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsSapOrderFormEntities)){
                kmsSapOrderFormEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsSapOrderFormEntities);
    }
}
